/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.authorization;

import com.ericsson.cms.epgmgmt.authorization.EPGLicenseUtils;
import com.ericsson.cms.epgmgmt.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class EPGManagerModuleProvider
implements IModuleProvider {
    private static final Logger logger = Logger.getLogger(EPGManagerModuleProvider.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (EPGLicenseUtils.isLicensed()) {
                modules.add(this.buildEPGManagerModule());
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)("Error in obtaining the license for EPG Manager " + e.getLocalizedMessage()));
        }
        return modules;
    }

    private IModule buildEPGManagerModule() {
        String moduleName = "EPGManager";
        String displayName = Messages.getString("EPGManagerModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("EPGManagerModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Plugin");
        permissions.add(new BasicPermission("Plugin", displayName, moduleName));
        return module;
    }
}

