/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.background;

import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IJobManager;
import com.ericsson.cms.epgmgmt.service.IJobTraceManager;
import com.ericsson.cms.epgmgmt.util.ConfigurationServiceUtil;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class EPGLogCleaner
implements Runnable {
    private static final String JOB_LOG_ALIVE_TIME = "taskJobLogAliveTime";
    private static final String ALARM_LOG_ALIVE_TIME = "alarmActivityLogAliveTime";
    private static final Logger LOGGER = Logger.getLogger(EPGLogCleaner.class);
    private ConfigurationServiceUtil configurationServiceUtil;
    private static final int DEFAULT_MONTH = 3;
    private IJobTraceManager jobTraceManager;
    private IJobManager jobManager;
    private IAlarmActivityLogManager alarmActivityLogManager;

    @Override
    public void run() {
        int jobMonth = 3;
        int alarmMonth = 3;
        try {
            jobMonth = this.configurationServiceUtil.getInt(JOB_LOG_ALIVE_TIME);
            alarmMonth = this.configurationServiceUtil.getInt(ALARM_LOG_ALIVE_TIME);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)"Can't find the taskJobLogAliveTime or alarmActivityLogAliveTime setting value, default value (3) is used.");
        }
        Date aliveDate = CalendarUtil.monthsInPast((int)jobMonth);
        int result = this.jobTraceManager.removeExpiredJobs(aliveDate);
        LOGGER.info((Object)("EPG task job traces logs that started before " + aliveDate + "[" + result + " record(s)] have been removed from JOB_TRACE"));
        result = this.jobManager.removeExpiredJob(aliveDate);
        LOGGER.info((Object)("EPG task execution logs that started before " + aliveDate + "[" + result + " record(s)] have been removed from EPG_JOB"));
        aliveDate = CalendarUtil.monthsInPast((int)alarmMonth);
        result = this.alarmActivityLogManager.removeExpiredLogs(aliveDate);
        LOGGER.info((Object)("EPG activity logs that started before " + aliveDate + "[" + result + " record(s)] have been removed from ALARM_ACTIVITYLOG"));
    }

    @Autowired
    public void setConfigurationServiceUtil(ConfigurationServiceUtil configurationServiceUtil) {
        this.configurationServiceUtil = configurationServiceUtil;
    }

    @Autowired
    public void setJobTraceManager(IJobTraceManager jobTraceManager) {
        this.jobTraceManager = jobTraceManager;
    }

    @Autowired
    public void setJobManager(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    @Autowired
    public void setAlarmActivityLogManager(IAlarmActivityLogManager alarmActivityLogManager) {
        this.alarmActivityLogManager = alarmActivityLogManager;
    }
}

