/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel;

import com.ericsson.cms.epgmgmt.camel.FtpOperationsExt;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.service.ActivityLogger;
import java.io.IOException;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.FtpConsumer;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

public class FtpConsumerExt
extends FtpConsumer {
    protected static final transient Logger LOGGER = Logger.getLogger(FtpConsumerExt.class);
    private Task task;

    public FtpConsumerExt(RemoteFileEndpoint<FTPFile> endpoint, Processor processor, RemoteFileOperations<FTPFile> fileOperations) {
        super(endpoint, processor, fileOperations);
    }

    protected void handleException(String message, Throwable t) {
        this.getExceptionHandler().handleException(message, t);
    }

    public void forceDisconnect() {
        boolean ftpOperation = this.getOperations() instanceof FtpOperationsExt;
        if (!ftpOperation) {
            return;
        }
        FtpOperationsExt ftpOpsExt = (FtpOperationsExt)this.getOperations();
        ftpOpsExt.forceDisconnect();
    }

    protected void connectIfNecessary() throws IOException {
        if (!this.loggedIn) {
            LOGGER.debug((Object)("Not connected/logged in, connecting to: " + this.remoteServer()));
            this.loggedIn = this.getOperations().connect((RemoteFileConfiguration)this.endpoint.getConfiguration());
            if (this.loggedIn) {
                String msgTemplate = "Connected and logged in to: %s. Please wait some time for retrieving the source data.";
                String jbossInfoStr = String.format(msgTemplate, this.remoteServer());
                LOGGER.info((Object)jbossInfoStr);
                RemoteFileConfiguration configuration = this.getEndpoint().getConfiguration();
                String hostInfo = String.format("%s://%s:%s", configuration.getProtocol(), configuration.getHost(), configuration.getPort());
                String activityInfoStr = String.format(msgTemplate, hostInfo);
                ActivityLogger.getInstance().log(PluginLogSeverity.INFORMATION, PluginLogComponent.WORKFLOW, activityInfoStr, this.task.getPartner().getId(), this.task.getPartner().getPartnerType().toString());
            }
        }
    }

    public void setTask(Task task) {
        this.task = task;
    }
}

