/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel;

import com.ericsson.cms.epgmgmt.camel.FtpConsumerExt;
import com.ericsson.cms.epgmgmt.camel.FtpOperationsExt;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;

public class FtpEndpointExt
extends FtpEndpoint<FTPFile> {
    private static Map<String, FtpOperationsExt> runningFtpOperations = new LinkedHashMap<String, FtpOperationsExt>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FtpOperationsExt> eldest) {
            return this.size() > 100;
        }
    };

    public FtpEndpointExt(String uri, RemoteFileComponent<FTPFile> component, RemoteFileConfiguration configuration) {
        super(uri, component, configuration);
    }

    public RemoteFileOperations<FTPFile> createRemoteFileOperations() throws Exception {
        FTPClient client = this.ftpClient;
        if (client == null) {
            client = this.createFtpClient();
            client.setControlKeepAliveTimeout(300L);
            client.setDataTimeout(300000);
        }
        if (this.getConfiguration().getConnectTimeout() > -1) {
            client.setConnectTimeout(60000);
            this.log.info("Set ftp connection time out is 60 seconds");
        }
        if (this.getConfiguration().getSoTimeout() > -1) {
            this.soTimeout = this.getConfiguration().getSoTimeout();
        }
        this.dataTimeout = this.getConfiguration().getTimeout();
        if (this.ftpClientParameters != null) {
            Object timeout = this.ftpClientParameters.remove("soTimeout");
            if (timeout != null) {
                this.soTimeout = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, timeout);
            }
            if ((timeout = this.ftpClientParameters.remove("dataTimeout")) != null) {
                this.dataTimeout = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, (Object)this.dataTimeout);
            }
            IntrospectionSupport.setProperties((Object)client, (Map)this.ftpClientParameters);
        }
        if (this.ftpClientConfigParameters != null) {
            if (this.ftpClientConfig == null) {
                this.ftpClientConfig = new FTPClientConfig();
            }
            IntrospectionSupport.setProperties((Object)this.ftpClientConfig, (Map)this.ftpClientConfigParameters);
        }
        if (this.dataTimeout > 0) {
            client.setDataTimeout(this.dataTimeout);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created FTPClient [connectTimeout: {}, soTimeout: {}, dataTimeout: {}]: {}", new Object[]{client.getConnectTimeout(), this.getSoTimeout(), this.dataTimeout, client});
        }
        FtpOperationsExt operations = new FtpOperationsExt(client, this.getFtpClientConfig());
        operations.setEndpoint((GenericFileEndpoint)this);
        return operations;
    }

    protected RemoteFileConsumer<FTPFile> buildConsumer(Processor processor) {
        try {
            return new FtpConsumerExt((RemoteFileEndpoint<FTPFile>)this, processor, this.createRemoteFileOperations());
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException((Endpoint)this, (Throwable)e);
        }
    }

    public synchronized boolean stopFtpOperations(String routeName) {
        boolean flag = false;
        FtpOperationsExt target = runningFtpOperations.get(routeName);
        if (target != null) {
            runningFtpOperations.remove(routeName);
            target.forceDisconnect();
            flag = true;
        }
        return flag;
    }

    public synchronized void bindRouteNameWithRunningFtpOperations(String fromRouteId, FtpOperationsExt ftpOperationsExt) {
        runningFtpOperations.put(fromRouteId, ftpOperationsExt);
    }

    public FtpOperationsExt getBindedRunningFtpOpertions(String routeId) {
        return runningFtpOperations.get(routeId);
    }
}

