/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.handler;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.exception.ExportToStagingException;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.exception.MergeException;
import com.ericsson.cms.epgmgmt.exception.NormalizationRuleException;
import com.ericsson.cms.epgmgmt.exception.PluginFrameworkException;
import com.ericsson.cms.epgmgmt.exception.ValidationRuleException;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelLogHandler
implements Processor {
    protected static final String ERROR_MSG = "ERROR_MSG";
    private static Logger snmpLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AlertLogger");
    private static Logger logger = Logger.getLogger(CamelLogHandler.class);
    private IPartnerManager partnerManager;
    private IAlarmActivityLogManager alarmActivityLogManager;
    private final Map<Class<?>, PluginLogComponent> exceptionStageMapping = new HashMap();
    private final Map<Class<?>, String> exceptionPatternMapping = new HashMap();

    public CamelLogHandler() {
        this.exceptionStageMapping.put(ExportToStagingException.class, PluginLogComponent.EXPORT_TO_STG);
        this.exceptionPatternMapping.put(ExportToStagingException.class, "Failure to publish EPG data for %s");
        this.exceptionStageMapping.put(ExportToXMLException.class, PluginLogComponent.EXPORT_TO_XML);
        this.exceptionPatternMapping.put(ExportToXMLException.class, "Failure to publish EPG data for %s");
        this.exceptionStageMapping.put(MergeException.class, PluginLogComponent.MERGE);
        this.exceptionPatternMapping.put(MergeException.class, "Merge failed for %s");
        this.exceptionStageMapping.put(NormalizationRuleException.class, PluginLogComponent.NORMALIZATION_RULES);
        this.exceptionPatternMapping.put(NormalizationRuleException.class, null);
        this.exceptionStageMapping.put(EPGPluginException.class, PluginLogComponent.PLUGIN);
        this.exceptionPatternMapping.put(EPGPluginException.class, null);
        this.exceptionStageMapping.put(PluginFrameworkException.class, PluginLogComponent.PLUGIN_FRAMEWORK);
        this.exceptionPatternMapping.put(PluginFrameworkException.class, null);
        this.exceptionStageMapping.put(ValidationRuleException.class, PluginLogComponent.VALIDATION_RULES);
        this.exceptionPatternMapping.put(ValidationRuleException.class, "Validation rule caused abort for %s");
        this.exceptionStageMapping.put(Exception.class, PluginLogComponent.WORKFLOW);
        this.exceptionPatternMapping.put(Exception.class, null);
    }

    public void logError(PluginLogComponent pluginLogComponent, String alertServerPattern, Exchange exchange, boolean addDetailsToMessage) {
        this.logError(pluginLogComponent, alertServerPattern, exchange);
    }

    public void logError(Exchange exchange) {
        Exception ex = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        PluginLogComponent comp = this.exceptionStageMapping.get(ex.getClass());
        String pattern = this.exceptionPatternMapping.get(ex.getClass());
        if (comp == null) {
            comp = PluginLogComponent.WORKFLOW;
        }
        this.logError(comp, pattern, exchange);
    }

    private void logError(PluginLogComponent pluginLogComponent, String alertServerPattern, Exchange exchange) {
        StringBuilder messageToLog = new StringBuilder();
        String msg = (String)exchange.getProperty(ERROR_MSG, String.class);
        long sourceId = -1L;
        String sourceType = null;
        String sourceDescription = "";
        messageToLog.append(!StringUtils.isBlank((String)msg) ? msg : this.extractExceptionMsg(exchange));
        Partner p = this.getPartner(exchange);
        if (p != null) {
            sourceType = p.getPartnerType().toString();
            sourceId = p.getId();
            sourceDescription = p.toString();
        }
        EmailAlertLevelEnum alertLevel = EmailAlertLevelEnum.ERROR;
        PluginLogSeverity servity = PluginLogSeverity.ERROR;
        Throwable throwable = this.getRootException(exchange);
        if (throwable instanceof CancellationException) {
            servity = PluginLogSeverity.WARNING;
            alertLevel = EmailAlertLevelEnum.WARNING;
            if (messageToLog.length() <= 0) {
                messageToLog.append("The job has been canceled.");
            }
        }
        if (messageToLog.length() <= 0) {
            messageToLog.append("unknown workflow error");
            logger.error((Object)"No error message found.");
        }
        this.alarmActivityLogManager.log(servity, pluginLogComponent, messageToLog.toString(), sourceId, sourceType);
        if (StringUtils.isNotBlank((String)sourceType)) {
            messageToLog.append(" for ").append(sourceType.toLowerCase()).append(": ").append(sourceDescription);
        }
        MessageEntryUtil.addMessage(new MessageEntry(alertLevel, "", messageToLog.toString(), pluginLogComponent));
        if (alertServerPattern != null) {
            snmpLogger.info((Object)String.format(alertServerPattern, sourceDescription));
        }
    }

    public void logInfo(Exchange exchange, String message) {
        long sourceId = -1L;
        String sourceType = "";
        String sourceDescription = "";
        Partner p = this.getPartner(exchange);
        if (p != null) {
            sourceType = p.getPartnerType().toString();
            sourceId = p.getId();
            sourceDescription = p.toString();
        }
        this.alarmActivityLogManager.log(PluginLogSeverity.INFORMATION, PluginLogComponent.SYSTEM, message + " for " + sourceDescription, sourceId, sourceType);
    }

    private Partner getPartner(Exchange exchange) {
        if (exchange.getIn() == null) {
            return null;
        }
        return this.partnerManager.getPartner(RouteBuilderUtils.getPartnerId(exchange));
    }

    private String extractExceptionMsg(Exchange exchange) {
        Throwable exception = this.getRootException(exchange);
        if (exception == null || exception.getMessage() == null) {
            return "";
        }
        logger.error((Object)"Exception caught", exception);
        StringBuilder messageToLog = new StringBuilder(exception.getMessage());
        if (!(exception instanceof GenericFileOperationFailedException)) {
            return messageToLog.toString();
        }
        String uri = (String)exchange.getProperty("CamelFailureEndpoint");
        if (StringUtils.contains((String)uri, (char)'?')) {
            uri = ((Object)uri.subSequence(0, uri.indexOf(63))).toString();
        }
        return messageToLog.append(" for URI " + uri).toString();
    }

    private Throwable getRootException(Exchange exchange) {
        Exception exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        Throwable root = ExceptionUtils.getRootCause((Throwable)exception);
        return root == null ? exception : root;
    }

    private RouteTypeEnum getRouteType(Exchange exchange) {
        return (RouteTypeEnum)exchange.getIn().getHeader("ROUTE_TYPE", RouteTypeEnum.class);
    }

    protected boolean isProvider(Exchange exchange) {
        return this.getRouteType(exchange) == RouteTypeEnum.PROVIDER;
    }

    @Autowired
    public void setPartnerManager(IPartnerManager partnerManager) {
        this.partnerManager = partnerManager;
    }

    @Autowired
    public void setAlarmActivityLogManager(IAlarmActivityLogManager alarmActivityLogManager) {
        this.alarmActivityLogManager = alarmActivityLogManager;
    }

    public void process(Exchange exchange) {
        this.logError(exchange);
    }
}

