/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.handler;

import com.ericsson.cms.epgmgmt.camel.handler.CamelLogHandler;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import org.apache.camel.Exchange;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.log4j.Logger;

public class ValidationErrorHandler
extends CamelLogHandler {
    private static Logger logger = Logger.getLogger(ValidationErrorHandler.class);

    @Override
    public void process(Exchange exchange) {
        this.logValidationError(exchange);
        SchemaValidationException exception = (SchemaValidationException)exchange.getProperty("CamelExceptionCaught", SchemaValidationException.class);
        if (exception != null) {
            exchange.setProperty("ERROR_MSG", (Object)("Fail to validate the data file[" + exchange.getIn() + "]"));
        }
        PluginLogComponent type = this.isProvider(exchange) ? PluginLogComponent.INGEST : PluginLogComponent.WORKFLOW;
        this.logError(type, "Failure to translate EPG error for %s", exchange, true);
    }

    private void logValidationError(Exchange exchange) {
        Exception exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        logger.error((Object)("Fail to validate thethe data file[" + exchange.getIn() + "]" + " for provider: " + exchange.getFromRouteId() + "\n" + exception.getMessage()));
    }
}

