/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.job.Job;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CompressProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        String format = this.getEndpointFileFormat(exchange);
        if (!format.isEmpty()) {
            File file = (File)exchange.getIn().getBody();
            this.compressFile(exchange, file, format);
        }
    }

    private String getEndpointFileFormat(Exchange exchange) {
        Job job = (Job)exchange.getProperty("EXCHANGE_JOB_PROPERTY", Job.class);
        String endpointFileName = job.getTask().getEndpoint().getFileName().toLowerCase();
        String format = "";
        if (endpointFileName.endsWith(".zip")) {
            format = "zip";
        } else if (endpointFileName.endsWith(".gz")) {
            format = "gz";
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressFile(Exchange exchange, File exportFileName, String format) throws IOException {
        block7: {
            FileInputStream instream;
            DeflaterOutputStream stream;
            String compressedFileName;
            block6: {
                compressedFileName = exportFileName.getPath() + "." + format;
                stream = null;
                instream = new FileInputStream(exportFileName);
                try {
                    if (StringUtils.equals((String)"zip", (String)format)) {
                        ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(compressedFileName));
                        zipStream.putNextEntry(new ZipEntry("result.xml"));
                        stream = zipStream;
                    }
                    if (!StringUtils.equals((String)"gz", (String)format)) break block6;
                    stream = new GZIPOutputStream(new FileOutputStream(compressedFileName));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)instream);
                    if (stream != null) {
                        IOUtils.closeQuietly(stream);
                    }
                    FileUtils.deleteQuietly((File)exportFileName);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)instream);
            if (stream != null) {
                IOUtils.closeQuietly(stream);
            }
            FileUtils.deleteQuietly((File)exportFileName);
            return;
            IOUtils.copy((InputStream)instream, (OutputStream)stream);
            exchange.getIn().setBody((Object)new File(compressedFileName));
            exchange.getIn().setHeader("CamelFileName", (Object)compressedFileName);
            IOUtils.closeQuietly((InputStream)instream);
            if (stream == null) break block7;
            IOUtils.closeQuietly((OutputStream)stream);
        }
        FileUtils.deleteQuietly((File)exportFileName);
    }
}

