/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.MergeException;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.service.EpgDbStore;
import com.ericsson.cms.epgmgmt.service.EpgDbStoreFactory;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.DataLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.GeneralRowExtractor;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.db.replicator.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.sql.DataSource;
import org.apache.camel.Exchange;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataLoaderProcessor
extends AbstractManageableProcessor {
    private static Logger logger = Logger.getLogger(DataLoaderProcessor.class);
    private static Logger auditLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AuditLogger");
    private static final String SCHEDULE_TABLE_NAME = "SCHEDULE";
    private EpgDbStoreFactory dbStoreFactory;
    private EpgDbStore epgDbOperation;
    private DataLoader dataLoader;
    private DataSource h2DataSource;
    private Table scheduleTable;
    private long providerId;
    private ITaskManager taskManager;
    private long startScheduleId;

    private void init(Exchange exchange) {
        this.providerId = RouteBuilderUtils.getPartnerId(exchange);
        this.epgDbOperation = this.dbStoreFactory.create();
        this.scheduleTable = this.epgDbOperation.getTable(SCHEDULE_TABLE_NAME);
    }

    @Override
    public void innerProcess(Exchange exchange) throws Exception {
        try {
            HashMap<String, Object[]> prodRecords;
            this.init(exchange);
            this.setProgress(5);
            this.loadStagingData2H2(this.providerId);
            this.setProgress(10);
            String selectSql = this.scheduleTable.getStgTable().getSelectSql();
            Map<String, Object[]> stagingRecords = this.getRecords(selectSql);
            boolean truncateProduction = this.taskManager.getBooleanSetting(this.getJob().getTask(), "IngestionConfig", "TruncateProduction");
            if (truncateProduction) {
                prodRecords = new HashMap();
                this.startScheduleId = 1L;
            } else {
                this.loadProductionData2H2(this.providerId);
                selectSql = this.scheduleTable.getSelectSql();
                prodRecords = this.getRecords(selectSql);
                this.startScheduleId = this.calculateStartScheduleId(prodRecords);
            }
            this.setProgress(60);
            this.addId2StagSchedule(stagingRecords, prodRecords);
            this.deleteStgScheduleRecords();
            Table stgSchedule = this.scheduleTable.getStgTable();
            this.setProgress(80);
            this.epgDbOperation.copyRecordsToH2StgTable(stagingRecords.values(), stgSchedule);
        }
        catch (Exception e) {
            logger.error((Object)("load data into Memory(H2) failed: " + e.getMessage()));
            String errMsg = "Failed to load EPG data into Memory(H2)";
            auditLogger.error((Object)errMsg);
            MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.ERROR, "", errMsg, PluginLogComponent.MERGE));
            throw new MergeException(errMsg, (Throwable)e);
        }
        finally {
            this.setProgress(100);
            logger.info((Object)"load done.");
        }
    }

    private Map<String, Object[]> getRecords(String getSql) {
        return this.dataLoader.load(getSql, (RowExtractor)new GeneralRowExtractor()).toSimpleMap();
    }

    private void loadStagingData2H2(long providerId) throws SQLException, IOException, InterruptedException {
        this.epgDbOperation.cleanupAllH2Objects();
        this.epgDbOperation.copyOracleStgToH2Stg(true, providerId);
    }

    private void loadProductionData2H2(long providerId) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("provider_id", String.format("in (%d)", providerId));
        try {
            this.epgDbOperation.copyOracleProdToH2Prod(model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addId2StagSchedule(Map<String, Object[]> stagingRecords, Map<String, Object[]> prodRecords) {
        for (String key : stagingRecords.keySet()) {
            Object[] stagingRecord = stagingRecords.get(key);
            Object[] prodRecord = prodRecords.get(key);
            stagingRecord[1] = prodRecord != null ? prodRecord[0] : Long.valueOf(this.startScheduleId++);
        }
    }

    private void deleteStgScheduleRecords() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.h2DataSource);
        jdbcTemplate.execute("truncate table STG_SCHEDULE");
    }

    private long calculateStartScheduleId(Map<String, Object[]> prodScheduleRecords) {
        BigDecimal maxScheduleId = BigDecimal.ZERO;
        for (Object[] record : prodScheduleRecords.values()) {
            BigDecimal scheduleId = (BigDecimal)record[0];
            if (scheduleId.compareTo(maxScheduleId) <= 0) continue;
            maxScheduleId = scheduleId;
        }
        long startScheduleId = maxScheduleId.longValue() + 1L;
        logger.debug((Object)("init schedule id:" + startScheduleId));
        return startScheduleId;
    }

    @Autowired
    public void setDbStoreFactory(EpgDbStoreFactory dbOperationFactory) {
        this.dbStoreFactory = dbOperationFactory;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setH2DataSource(DataSource h2DataSource) {
        this.h2DataSource = h2DataSource;
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }
}

