/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToStagingException;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.service.EpgDbStore;
import com.ericsson.cms.epgmgmt.service.EpgDbStoreFactory;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.service.PublishFilterSource;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.PartnerIdThreadLocal;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportToStagingProcessor
extends AbstractManageableProcessor {
    private static Logger auditLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AuditLogger");
    private static Logger logger = Logger.getLogger(ExportToStagingProcessor.class);
    private EpgDbStoreFactory dbOperationFactory;
    private PublishFilterSource publishFilterSource;
    private EpgDbStore epgDbOperation;
    private ITaskManager taskManager;

    @Override
    public void innerProcess(Exchange exchange) throws Exception {
        try {
            this.setProgress(5);
            logger.info((Object)"exec executeExportToStaging");
            Task task = this.taskManager.getTask(RouteBuilderUtils.getTaskId(exchange));
            this.publishFilterSource.init(task);
            logger.info((Object)"create dbOperation");
            this.epgDbOperation = this.dbOperationFactory.create();
            PartnerIdThreadLocal.setPartnerId(task.getPartner().getId());
            this.checkCancel();
            HashMap<String, String> model = new HashMap<String, String>();
            String providerIds = this.publishFilterSource.getProviderId();
            model.put("provider_id", providerIds);
            this.epgDbOperation.copyMasterProdToH2Exp(task, this.publishFilterSource);
            this.setProgress(100);
            this.epgDbOperation.logInfo("Copy data finished.", PluginLogComponent.EXPORT_TO_STG, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Receiver);
        }
        catch (Exception e) {
            String errMsg = "Failed to export EPG data to exp tables";
            auditLogger.error((Object)errMsg);
            MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.CRITICAL, "", errMsg, PluginLogComponent.EXPORT_TO_STG));
            logger.error((Object)errMsg, (Throwable)e);
            throw new ExportToStagingException(errMsg, (Throwable)e);
        }
        finally {
            if (this.epgDbOperation != null) {
                this.epgDbOperation.dropH2Prod();
            }
            logger.info((Object)"export done");
        }
    }

    @Autowired
    public void setDbStoreFactory(EpgDbStoreFactory dbOperationFactory) {
        this.dbOperationFactory = dbOperationFactory;
    }

    @Autowired
    public void setPublishFilterSource(PublishFilterSource publishFilterSource) {
        this.publishFilterSource = publishFilterSource;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.epgDbOperation != null) {
            this.epgDbOperation.shutdownReplicator();
        }
    }
}

