/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.IEPGExportGuideData;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.util.ConfigProperties;
import com.ericsson.cms.epgmgmt.util.ExportTaskUtil;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import java.io.File;
import java.util.concurrent.CancellationException;
import org.apache.camel.Exchange;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportToXMLProcessor
extends AbstractManageableProcessor {
    private static Logger logger = Logger.getLogger(ExportToXMLProcessor.class);
    private static Logger auditLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AuditLogger");
    private IEPGExportGuideData epgExportGuideData;
    private ITaskManager taskManager;
    private IEPGMetadataManager metadataManager;
    private Task task;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void innerProcess(Exchange exchange) throws Exception {
        try {
            this.setProgress(5);
            this.task = this.taskManager.getTask(RouteBuilderUtils.getTaskId(exchange));
            Validate.notNull((Object)this.task, (String)"Cannot find the publisher");
            EpgFormat format = this.metadataManager.getEpgFormat(this.task);
            if (format == null && !this.task.getFormatName().equalsIgnoreCase("ETV")) {
                throw new EPGPluginException("Loading plug-in failed.");
            }
            String etvFormat = format == null || format.isETV() ? "ETV_18" : ExportTaskUtil.findETVFormatByPlugin(this.task);
            logger.info((Object)"Executing EpgExportGuideData.exportGuideData() - create XML");
            auditLogger.info((Object)("Exporting to XML for " + this.task.toString()));
            this.epgExportGuideData.exportGuideData(this.task, ExportETVTypeEnum.valueOf(etvFormat), ConfigProperties.getFtpTempFolderFromDatabase());
            exchange.getIn().setBody((Object)new File(ConfigProperties.getExportedETVFileName()));
            this.setProgress(100);
        }
        catch (Exception e) {
            this.processException(e);
        }
        finally {
            this.task = null;
        }
    }

    private void processException(Exception e) {
        Throwable rootCause;
        logger.error((Object)("Executing EpgExportGuideData.exportGuideData() - create XML failed: " + e.getMessage()), (Throwable)e);
        String errMsg = "Failed to export EPG data to XML";
        auditLogger.error((Object)errMsg);
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.ERROR, "", errMsg, PluginLogComponent.EXPORT_TO_XML));
        ExportToXMLException ex = e instanceof EPGPluginException ? new ExportToXMLException("Loading plug-in failed.") : ((rootCause = ExceptionUtils.getRootCause((Throwable)e)) instanceof InterruptedException || e instanceof InterruptedException ? new ExportToXMLException(errMsg, (Throwable)new CancellationException()) : (e instanceof ExportToXMLException ? (ExportToXMLException)e : new ExportToXMLException(errMsg, (Throwable)e)));
        throw ex;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.task != null) {
            this.epgExportGuideData.stopExportingGuideData();
        }
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Autowired
    public void setEpgExportGuideData(IEPGExportGuideData epgExportGuideData) {
        this.epgExportGuideData = epgExportGuideData;
    }

    @Autowired
    public void setMetadataManager(IEPGMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }
}

