/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.Synchronization;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public final class FileDeleter
implements Synchronization,
Processor {
    private static final Logger logger = Logger.getLogger(FileDeleter.class);

    private void deleteFiles(Exchange exchange) {
        String filename = null;
        try {
            filename = ((File)exchange.getIn().getBody()).getAbsolutePath();
            FileUtils.deleteQuietly((File)new File(filename));
            logger.debug((Object)("Deleted " + filename));
        }
        catch (Exception e) {
            logger.error((Object)(" Unable to delete " + filename + " " + e.getMessage()));
        }
    }

    public void onComplete(Exchange exchange) {
        this.deleteFiles(exchange);
    }

    public void onFailure(Exchange exchange) {
        this.deleteFiles(exchange);
    }

    public void process(Exchange exchange) {
        exchange.getUnitOfWork().addSynchronization((Synchronization)this);
    }
}

