/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.entity.Endpoint;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.epgmgr.plugin.util.StringUtils;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.io.FilenameUtils;

public class FileNameMatcherProcessor
implements Processor {
    public static final String LACK_FILE_HEADER = "Lack_File";

    public void process(Exchange exchange) throws Exception {
        String[] matchers;
        exchange.getIn().setHeader(LACK_FILE_HEADER, (Object)Boolean.FALSE);
        Job job = (Job)exchange.getProperty("EXCHANGE_JOB_PROPERTY", Job.class);
        Endpoint endpoint = job.getTask().getEndpoint();
        String fileNameMatcher = endpoint.getFileNameMatcher();
        if (StringUtils.isBlank((String)fileNameMatcher)) {
            return;
        }
        List groupedExchanges = (List)exchange.getProperty("CamelGroupedExchange", List.class);
        if (groupedExchanges == null) {
            return;
        }
        String[] fileNames = new String[groupedExchanges.size()];
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = (String)((Exchange)groupedExchanges.get(i)).getIn().getHeader("CamelFileNameOnly", String.class);
        }
        for (String matcher : matchers = fileNameMatcher.split(";")) {
            if (this.findMatchFile(matcher, fileNames)) continue;
            String errorMessage = "Some files are missing: " + matcher;
            job.setStatus(JobStatusEnum.FAILDED);
            job.getContext().put(LACK_FILE_HEADER, Boolean.TRUE);
            exchange.getIn().setHeader(LACK_FILE_HEADER, (Object)Boolean.TRUE);
            job.getJobEntity().setErrorMessage("ERR_FILE_MISSING");
            job.getSteps().get(0).setErrorMessage(errorMessage);
            job.getSteps().get(0).setStatus(JobStatusEnum.FAILDED);
            break;
        }
    }

    private boolean findMatchFile(String matcher, String[] fileNames) {
        if (matcher.isEmpty()) {
            return true;
        }
        for (String fileName : fileNames) {
            if (!FilenameUtils.wildcardMatch((String)fileName, (String)matcher)) continue;
            return true;
        }
        return false;
    }
}

