/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.entitymanager.EPGMetadataManager;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;

public class IngestTaskHeaderProcessor
implements Processor {
    private final Task task;
    private IEPGMetadataManager metadataManager = (IEPGMetadataManager)ApplicationContextUtil.getBean((String)"epgMetadataManager", EPGMetadataManager.class);

    public IngestTaskHeaderProcessor(Task task) {
        this.task = task;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        message.setHeader("ROUTE_TYPE", (Object)RouteTypeEnum.PROVIDER);
        message.setHeader("PARTNER_ID", (Object)this.task.getPartner().getId());
        message.setHeader("TASK_ID", (Object)this.task.getId());
        EpgFormat format = this.metadataManager.getEpgFormat(this.task);
        if (format == null) {
            this.loadPluginError(exchange, format);
            throw new EPGPluginException("Loading plug-in failed.");
        }
        boolean isETV = format == null || format.isETV();
        message.setHeader("IS_ETV", (Object)isETV);
        try {
            IEPGManagerProvider plugin = PluginFactory.getProviderPlugin(new File(format.getJarName()));
            if (plugin == null) {
                throw new EPGPluginException("Loading plug-in failed.");
            }
            message.setHeader(PluginAttribute.VALIDATE.toString(), (Object)EPGPluginManager.validateForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.VALIDATIONRULE.toString(), (Object)EPGPluginManager.validationRuleForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.NORMALIZATIONRULE.toString(), (Object)EPGPluginManager.nomalizationRuleForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.MERGE.toString(), (Object)EPGPluginManager.mergeForPlugin((IEPGManagerPlugin)plugin));
        }
        catch (Exception ex) {
            this.loadPluginError(exchange, format);
            throw ex;
        }
    }

    private void loadPluginError(Exchange exchange, EpgFormat format) {
        Job job = (Job)exchange.getProperty("EXCHANGE_JOB_PROPERTY", Job.class);
        job.stepError("Loading plug-in failed.");
        job.setStatus(JobStatusEnum.FAILDED);
        job.getJobEntity().setErrorMessage("Loading plug-in failed.");
    }
}

