/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.runtime.MemoryChecker;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.util.JobCommentsUtil;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MemoryCheckProcessor
implements Processor {
    private static Logger logger = Logger.getLogger(MemoryCheckProcessor.class);
    private MemoryChecker memoryChecker;

    public void process(Exchange exchange) throws Exception {
        if (!this.memoryChecker.enoughMemory()) {
            logger.warn((Object)("The free memory size(" + this.memoryChecker.getAvailableMemory() + " G) of the CMS system is not enough now, cancel the job"));
            IJob job = (IJob)exchange.getProperty("EXCHANGE_JOB_PROPERTY", Job.class);
            JobCommentsUtil.updateComments(job.getJobEntity(), "job.comments.not.enough.memory");
            job.cancel();
        }
    }

    @Autowired
    public void setMemoryChecker(MemoryChecker memoryChecker) {
        this.memoryChecker = memoryChecker;
    }
}

