/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.MergeException;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.job.ThreadLocalProgressMonitor;
import com.ericsson.cms.epgmgmt.service.EpgDbStore;
import com.ericsson.cms.epgmgmt.service.EpgDbStoreFactory;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.util.ConfigurationServiceUtil;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.PartnerIdThreadLocal;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import com.ericsson.cms.epgmgmt.utility.time.TimeUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.apache.camel.Exchange;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MergeProcessor
extends AbstractManageableProcessor {
    private static Logger logger = Logger.getLogger(MergeProcessor.class);
    private static Logger auditLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AuditLogger");
    private EpgDbStoreFactory dbStoreFactory;
    private IPartnerManager partnerManager;
    private ITaskManager taskManager;
    private ConfigurationServiceUtil configurationServiceUtil;

    @Override
    public void innerProcess(Exchange exchange) throws Exception {
        EpgDbStore epgDbStore = this.dbStoreFactory.create();
        try {
            Provider provider = this.partnerManager.getProvider(RouteBuilderUtils.getPartnerId(exchange));
            logger.info((Object)"Executing memory MERGE()");
            auditLogger.info((Object)(" Merging to production for " + provider.toString()));
            boolean overwriteWithEmpty = this.taskManager.getBooleanSetting(this.getJob().getTask(), "IngestionConfig", "OverwriteWithEmpty");
            boolean truncateProduction = this.taskManager.getBooleanSetting(this.getJob().getTask(), "IngestionConfig", "TruncateProduction");
            String historyTemp = this.configurationServiceUtil.get("history");
            int history = 0;
            if (StringUtils.isNotBlank((String)historyTemp)) {
                history = Integer.parseInt(historyTemp);
            }
            this.mergeH2Data2OracleProduction(epgDbStore, provider.getName(), provider.getId(), overwriteWithEmpty, truncateProduction, history);
        }
        catch (Exception e) {
            logger.error((Object)("memory MERGE failed: " + e.getMessage()));
            String errMsg = "Failed to merge EPG data to production tables";
            auditLogger.error((Object)errMsg);
            MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.ERROR, "", errMsg, PluginLogComponent.MERGE));
            throw new MergeException(errMsg, (Throwable)e);
        }
        finally {
            logger.info((Object)"merge done. Cleanup the memory data.");
            try {
                epgDbStore.cleanupAllH2Objects();
                epgDbStore.shutdownReplicator();
            }
            catch (SQLException e) {}
        }
    }

    private void mergeH2Data2OracleProduction(EpgDbStore epgDbOperation, String providerName, long providerId, boolean overwriteWithEmpty, boolean truncateProduction, int daysBehindNowToKeep) throws IOException, SQLException, ExecutionException {
        long mergeStartTime = System.currentTimeMillis();
        ThreadLocalProgressMonitor.reportProgress(0);
        epgDbOperation.logInfo("Begin to merge memory data to master", PluginLogComponent.MERGE, providerId, PartnerTypeEnum.Provider);
        epgDbOperation.copyOracleStgToH2Stg(false, providerId);
        ThreadLocalProgressMonitor.reportProgress(25);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("provider_id", String.format("in (%d)", providerId));
        if (truncateProduction) {
            epgDbOperation.truncateOracleProduction(providerId);
            epgDbOperation.dropAndRecreateH2Prod();
        } else {
            epgDbOperation.purgeMasterProd(daysBehindNowToKeep, providerId);
            ThreadLocalProgressMonitor.reportProgress(26);
            epgDbOperation.logInfo("Copy master production tables to memory production tables.", PluginLogComponent.MERGE, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Provider);
            epgDbOperation.copyOracleProdToH2Prod(model);
            ThreadLocalProgressMonitor.reportProgress(48);
            epgDbOperation.deleteOldScheduleData();
            ThreadLocalProgressMonitor.reportProgress(49);
            epgDbOperation.truncateOracleProduction(providerId);
        }
        ThreadLocalProgressMonitor.reportProgress(50);
        epgDbOperation.mergeH2StgToH2Prod(overwriteWithEmpty, model);
        ThreadLocalProgressMonitor.reportProgress(75);
        epgDbOperation.copyH2ProdToOracleProd(model);
        ThreadLocalProgressMonitor.reportProgress(100);
        epgDbOperation.generateMergeReport(providerId);
        epgDbOperation.logInfo(String.format("Finished EPG merge for %s(took %s)", providerName, TimeUtil.getTimeTook((long)(System.currentTimeMillis() - mergeStartTime))), PluginLogComponent.MERGE, providerId, PartnerTypeEnum.Provider);
    }

    @Autowired
    public void setDbStoreFactory(EpgDbStoreFactory dbOperationFactory) {
        this.dbStoreFactory = dbOperationFactory;
    }

    @Autowired
    public void setPartnerManager(IPartnerManager partnerManager) {
        this.partnerManager = partnerManager;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Autowired
    public void setConfigurationServiceUtil(ConfigurationServiceUtil configurationServiceUtil) {
        this.configurationServiceUtil = configurationServiceUtil;
    }
}

