/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.processor;

import com.ericsson.cms.epgmgmt.normalizationrules.IEPGRulesNormalizer;
import com.ericsson.cms.epgmgmt.util.PartnerIdThreadLocal;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;

public class PublisherNormalizationProcessor
implements Processor {
    private IEPGRulesNormalizer epgRulesNormalizer;

    public void process(Exchange exchange) throws Exception {
        long publisherId = (Long)exchange.getIn().getHeader("PARTNER_ID", Long.class);
        PartnerIdThreadLocal.setPartnerId(publisherId);
        this.epgRulesNormalizer.applyPublisherNormalizationRules(publisherId);
    }

    @Autowired
    public void setEpgRulesNormalizer(IEPGRulesNormalizer epgRulesNormalizer) {
        this.epgRulesNormalizer = epgRulesNormalizer;
    }
}

