/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.quartz;

import com.ericsson.cms.epgmgmt.camel.quartz.SimpleJob;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.service.IJobManager;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.service.ScheduleException;
import com.ericsson.cms.epgmgmt.service.TaskJobScheduler;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskJobQuartzScheduler
implements TaskJobScheduler {
    public static final String EPG_QUARTZ_GROUP = "EPG";
    private static final long DEFAULT_DELAY = 10000L;
    private ITaskManager taskManager;
    private Scheduler scheduler = null;
    private final Logger logger = Logger.getLogger(TaskJobQuartzScheduler.class);
    private ITaskJobExecutor taskExecutor;
    private IJobManager jobManager;
    private StdSchedulerFactory schedulerFactory;

    @Override
    public void scheduleAllTask() {
        for (Task task : this.taskManager.getTasks()) {
            this.scheduleTask(task);
        }
    }

    @Override
    public boolean scheduleTask(Task task) {
        this.logger.debug((Object)("Scheduling for task[" + task.getName() + "(" + task.getId() + ")] of partner[" + task.getPartner().getName() + "]"));
        if (!task.isEnabled()) {
            this.logger.info((Object)String.format("Skipped the disabled task %s.", task.getName()));
            return false;
        }
        if (task.getTriggerType() == TaskTriggerTypeEnum.FREQUENCY) {
            this.logger.warn((Object)String.format("Task trigger type FREQUENCY is not supported!", task.getTriggerType().toString()));
            return false;
        }
        Collection<Trigger> triggers = this.createTriggers(task);
        if (triggers.isEmpty()) {
            return false;
        }
        JobDetail jobDetail = this.createJobDetail(task);
        try {
            this.scheduler.addJob(jobDetail, true);
            for (Trigger trigger : triggers) {
                this.scheduler.scheduleJob(trigger);
            }
        }
        catch (SchedulerException e) {
            this.logger.error((Object)"Scheduling task error:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean scheduleOnceTask(Task task, Date startDate, Map<String, Object> params) {
        this.logger.debug((Object)("Scheduling for task[" + task.getName() + "(" + task.getId() + ")] of partner[" + task.getPartner().getName() + "] once"));
        if (!task.isEnabled()) {
            this.logger.info((Object)String.format("Skipped the disabled task %s.", task.getName()));
            return false;
        }
        Trigger trigger = this.createOnceTrigger(task, startDate);
        JobDetail jobDetail = this.createOnceJobDetail(task, params);
        try {
            this.scheduler.addJob(jobDetail, true);
            this.scheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            this.logger.error((Object)"Scheduling task error:", (Throwable)e);
            return false;
        }
        return true;
    }

    private JobDetail createJobDetail(Task task) {
        JobDetail job = new JobDetail(this.getJobName(task.getId()), EPG_QUARTZ_GROUP, SimpleJob.class);
        JobDataMap dataMap = job.getJobDataMap();
        dataMap.put((Object)"TASK", (Object)task);
        dataMap.put((Object)"ITaskJobExecutor", (Object)this.taskExecutor);
        return job;
    }

    private JobDetail createOnceJobDetail(Task task, Map<String, Object> params) {
        JobDetail job = new JobDetail(this.getOnceJobName(task.getId()), EPG_QUARTZ_GROUP, SimpleJob.class);
        JobDataMap dataMap = job.getJobDataMap();
        dataMap.put((Object)"TASK", (Object)task);
        dataMap.put((Object)"ITaskJobExecutor", (Object)this.taskExecutor);
        dataMap.putAll(params);
        return job;
    }

    private String getJobName(long taskId) {
        return "Job_" + taskId;
    }

    private String getOnceJobName(long taskId) {
        return "OnceJob_" + taskId;
    }

    private Collection<Trigger> createTriggers(Task task) {
        Collection<Trigger> triggers = null;
        switch (task.getTriggerType()) {
            case MANUAL: {
                this.logger.info((Object)String.format("Skipped the manual task %s", task.getName()));
                triggers = Collections.emptyList();
                break;
            }
            case FREQUENCY: {
                triggers = this.createFrequencyTrigger(task);
                break;
            }
            case SCHEDULE: {
                triggers = this.createCronTriggers(task);
            }
        }
        return triggers;
    }

    private Collection<Trigger> createFrequencyTrigger(Task task) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        String triggerName = this.getTriggerName(task);
        String triggerGroup = this.getTriggerGroup(task.getPartner());
        String jobName = this.getJobName(task.getId());
        try {
            triggers.add((Trigger)new SimpleTrigger(triggerName, triggerGroup, jobName, EPG_QUARTZ_GROUP, this.getInitialTime(task), null, SimpleTrigger.REPEAT_INDEFINITELY, TimeUnit.SECONDS.toMillis(Long.parseLong(task.getTriggerValue()))));
        }
        catch (NumberFormatException e) {
            this.logger.warn((Object)String.format("Skipped the trigger of task %s because the trigger value is not numeric :%s", task.getName(), task.getTriggerValue()), (Throwable)e);
        }
        return triggers;
    }

    private Collection<Trigger> createCronTriggers(Task task) {
        if (StringUtils.isBlank((String)task.getTriggerValue())) {
            this.logger.warn((Object)String.format("Skipped the trigger of the task %s because the trigger value is blank", task.getName()));
            return Collections.emptyList();
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        String triggerName = this.getTriggerName(task);
        String triggerGroup = this.getTriggerGroup(task.getPartner());
        String jobName = this.getJobName(task.getId());
        String[] cronExps = StringUtils.split((String)task.getTriggerValue(), (char)'|');
        for (int i = 0; i < cronExps.length; ++i) {
            String cronExp = cronExps[i];
            try {
                triggers.add((Trigger)new CronTrigger(triggerName + "_" + i, triggerGroup, jobName, EPG_QUARTZ_GROUP, cronExp));
                continue;
            }
            catch (ParseException e) {
                this.logger.warn((Object)String.format("Skipped the trigger of task %s because of parsing error:%s", task.getName(), cronExp), (Throwable)e);
            }
        }
        return triggers;
    }

    private Trigger createOnceTrigger(Task task, Date startDate) {
        String triggerName = this.getOnceTriggerName(task);
        String triggerGroup = this.getTriggerGroup(task.getPartner());
        String jobName = this.getOnceJobName(task.getId());
        return new SimpleTrigger(triggerName, triggerGroup, jobName, EPG_QUARTZ_GROUP, startDate, null, 0, 0L);
    }

    private String getTriggerGroup(Partner partner) {
        return "TriggerGroup_" + partner.getPartnerType().toString() + "_" + partner.getId() + "_" + partner.getName();
    }

    private String getTriggerName(Task task) {
        return "Trigger_" + task.getType().toString() + "_" + task.getId() + "_" + task.getName();
    }

    private String getOnceTriggerName(Task task) {
        return "OnceTrigger_" + task.getType().toString() + "_" + task.getId() + "_" + task.getName();
    }

    private Date getInitialTime(Task task) {
        long recentRunning = this.jobManager.findRecentStartTime(task.getId());
        long now = new Date().getTime() + 10000L;
        long frequency = TimeUnit.SECONDS.toMillis(Long.parseLong(task.getTriggerValue()));
        if (recentRunning == 0L || recentRunning + frequency < now) {
            return new Date(now);
        }
        return new Date(recentRunning + frequency);
    }

    @Override
    public void stopScheduleTask(long taskId) throws ScheduleException {
        try {
            this.scheduler.deleteJob(this.getJobName(taskId), EPG_QUARTZ_GROUP);
            this.scheduler.deleteJob(this.getOnceJobName(taskId), EPG_QUARTZ_GROUP);
            this.logger.debug((Object)("Stopping schedule for task[" + taskId + "]"));
        }
        catch (SchedulerException e) {
            throw new ScheduleException((Exception)((Object)e));
        }
    }

    @Override
    public boolean isScheduling(long taskId) throws ScheduleException {
        try {
            Trigger[] triggers = this.scheduler.getTriggersOfJob(this.getJobName(taskId), EPG_QUARTZ_GROUP);
            return triggers != null && triggers.length > 0;
        }
        catch (SchedulerException e) {
            throw new ScheduleException((Exception)((Object)e));
        }
    }

    @Override
    public long getNextExecutionTime(long taskId) {
        long result = Long.MAX_VALUE;
        try {
            Trigger[] triggers;
            for (Trigger trigger : triggers = this.scheduler.getTriggersOfJob(this.getJobName(taskId), EPG_QUARTZ_GROUP)) {
                result = Math.min(result, trigger.getNextFireTime().getTime());
            }
        }
        catch (SchedulerException e) {
            this.logger.error((Object)"Get next execution time error:", (Throwable)e);
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Autowired
    public void setTaskExecutor(ITaskJobExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Autowired
    public void setJobManager(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    @PostConstruct
    public void start() {
        if (this.schedulerFactory == null) {
            this.schedulerFactory = new StdSchedulerFactory();
        }
        if (this.scheduler != null) {
            this.logger.warn((Object)"The scheduler has started.");
            return;
        }
        try {
            Properties quartzProperties = new Properties();
            quartzProperties.load(this.getClass().getResourceAsStream("epgtask_quartz.properties"));
            this.schedulerFactory.initialize(quartzProperties);
            this.scheduler = this.schedulerFactory.getScheduler();
            this.scheduler.start();
            this.scheduleAllTask();
        }
        catch (SchedulerException e) {
            this.logger.fatal((Object)"Error happened while starting the EPG Task Scheduler", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Error happened while loading the epgtask_quartz.properties", (Throwable)e);
        }
    }

    @PreDestroy
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            this.logger.fatal((Object)"Error happened while shutting down the EPG Task Scheduler", (Throwable)e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.scheduler != null;
    }

    public void setSchedulerFactory(StdSchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }
}

