/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routebuilder;

import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.exception.ServiceException;
import com.ericsson.cms.epgmgmt.service.IJob;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.commons.lang.StringUtils;

public abstract class BaseRouteBuilder
extends RouteBuilder {
    public static final String IS_ETV = "IS_ETV";

    protected Endpoint createEndpoint(IJob job) throws URISyntaxException {
        Task task = job.getTask();
        String endpointURI = this.getEndpointURI(task.getEndpoint());
        Endpoint endpoint = super.getContext().getEndpoint(endpointURI);
        if (endpoint instanceof ScheduledPollEndpoint) {
            HashMap<String, PollingConsumerPollStrategy> consumerProperties = ((ScheduledPollEndpoint)endpoint).getConsumerProperties();
            if (consumerProperties == null) {
                consumerProperties = new HashMap<String, PollingConsumerPollStrategy>();
                ((ScheduledPollEndpoint)endpoint).setConsumerProperties(consumerProperties);
            }
            consumerProperties.put("pollStrategy", this.getPollStrategy());
        }
        return endpoint;
    }

    protected abstract PollingConsumerPollStrategy getPollStrategy();

    public String getEndpointURI(com.ericsson.cms.epgmgmt.entity.Endpoint endpoint) throws URISyntaxException {
        EndpointSchemeEnum endPointScheme = endpoint.getEndpointType();
        String providerEndpointUri = null;
        StringBuilder filePath = new StringBuilder("/");
        String username = StringUtils.isBlank((String)endpoint.getUserName()) ? null : endpoint.getUserName();
        switch (endPointScheme) {
            case ftp: {
                if (endpoint.getFolder() != null) {
                    filePath.append(endpoint.getFolder());
                }
                providerEndpointUri = new URI(endPointScheme.name(), username, endpoint.getServerIp(), (int)endpoint.getPort(), filePath.toString(), this.getOptionsForEndpoint(endpoint), null).toString();
                break;
            }
            case sftp: {
                if (endpoint.getFolder() != null) {
                    filePath.append(endpoint.getFolder());
                }
                providerEndpointUri = new URI(endPointScheme.name(), username, endpoint.getServerIp(), (int)endpoint.getPort(), filePath.toString(), this.getOptionsForEndpoint(endpoint), null).toString();
                break;
            }
            case file: {
                providerEndpointUri = new URI(endPointScheme.name(), null, endpoint.getFolder(), -1, null, this.getOptionsForEndpoint(endpoint), null).toString();
                break;
            }
            default: {
                throw new ServiceException("Endpoint of type - " + endPointScheme + " not supported");
            }
        }
        return providerEndpointUri;
    }

    abstract String getOptionsForEndpoint(com.ericsson.cms.epgmgmt.entity.Endpoint var1);
}

