/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routebuilder;

import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.impl.DefaultCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class CamelFtpOptionsVerifier {
    private static Logger logger = LoggerFactory.getLogger(CamelFtpOptionsVerifier.class);
    public static final String PROVIDER_FTP_OPTS = "&throwExceptionOnConnectFailed=true&maximumReconnectAttempts=0&disconnect=true&noop=false&binary=true&delete=false&separator=UNIX";
    public static final String PROVIDER_SFTP_OPTS = "&throwExceptionOnConnectFailed=true&maximumReconnectAttempts=0&disconnect=true&noop=false&binary=true&delete=false&separator=UNIX";
    public static final String RECEIVER_FTP_OPTS = "&maximumReconnectAttempts=0&disconnect=true&separator=UNIX";
    public static final String RECEIVER_SFTP_OPTS = "&maximumReconnectAttempts=0&disconnect=true&separator=UNIX";

    private CamelFtpOptionsVerifier() {
    }

    public static String verify(EndpointSchemeEnum endpointScheme, String optionStr) {
        String[] options;
        optionStr = CamelFtpOptionsVerifier.normalizeOptionStr(optionStr);
        logger.info(String.format("verifying camel %s option:%s...", endpointScheme.name(), optionStr));
        for (String optionValuePair : options = optionStr.split("&")) {
            String errMsg = CamelFtpOptionsVerifier.verifyByCamel(endpointScheme, optionValuePair);
            if (errMsg == null) continue;
            return CamelFtpOptionsVerifier.composeErrMsg(optionValuePair, errMsg);
        }
        return null;
    }

    private static String verifyByCamel(EndpointSchemeEnum endpointScheme, String optionStr) {
        DefaultCamelContext context = new DefaultCamelContext();
        int dummyPort = 21;
        try {
            String uri = new URI(endpointScheme.name(), "dummyUser", "127.0.0.1", 21, "/", optionStr, null).toString();
            context.getEndpoint(uri);
        }
        catch (URISyntaxException e) {
            return e.getMessage();
        }
        catch (ResolveEndpointFailedException e) {
            return e.getMessage();
        }
        return null;
    }

    private static String composeErrMsg(String optionStr, String rawErrMsg) {
        String[] items = rawErrMsg.split(" due to: ");
        switch (items.length) {
            case 2: {
                return String.format("%s : %s", optionStr, items[1]);
            }
            case 3: {
                items = rawErrMsg.split("couldn't be set on the endpoint. ");
                return String.format("%s : %s", optionStr, items[1]);
            }
        }
        return String.format("%s : %s", optionStr, rawErrMsg);
    }

    private static String normalizeOptionStr(String optionStr) {
        return StringUtils.trimLeadingCharacter((String)optionStr, (char)'&');
    }
}

