/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routebuilder;

import com.ericsson.cms.epgmgmt.camel.handler.CamelLogHandler;
import com.ericsson.cms.epgmgmt.camel.processor.CompressProcessor;
import com.ericsson.cms.epgmgmt.camel.processor.FileDeleter;
import com.ericsson.cms.epgmgmt.camel.processor.MemoryCheckProcessor;
import com.ericsson.cms.epgmgmt.camel.routebuilder.BaseRouteBuilder;
import com.ericsson.cms.epgmgmt.camel.routebuilder.CamelFtpOptionsVerifier;
import com.ericsson.cms.epgmgmt.camel.routepolicy.CustomPollingConsumerPollStrategy;
import com.ericsson.cms.epgmgmt.camel.routepolicy.ExportJobRoutePolicy;
import com.ericsson.cms.epgmgmt.entity.Endpoint;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import java.net.URISyntaxException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.commons.lang.StringUtils;

public class ExportJobRouteBuilder
extends BaseRouteBuilder {
    private static final String TIMER_URI = "timer:TIMER_FOR_PUBLISHER?daemon=false&period=0&delay=0&repeatCount=1";
    private IJob job;
    private ExportJobRoutePolicy routePolicy;
    private CamelLogHandler camelLogHandler;
    private PollingConsumerPollStrategy pollStrategy;
    private String storeFileStepName;
    private String camelFtpOptions;
    private String camelSftpOptions;
    private IEPGMetadataManager metadataManager;
    private MemoryCheckProcessor memoryCheckProcessor;

    public void configure() throws URISyntaxException {
        this.onException(GenericFileOperationFailedException.class).handled(true).maximumRedeliveries(0).bean((Object)this.camelLogHandler);
        this.buildRoute();
    }

    private void buildRoute() throws URISyntaxException {
        Task task = this.job.getTask();
        EpgFormat format = this.metadataManager.getEpgFormat(task);
        boolean isETV = format == null ? true : format.isETV();
        String routeId = RouteBuilderUtils.getRouteId(task);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(TIMER_URI).routePolicy(new RoutePolicy[]{this.routePolicy}).routeId(routeId).setHeader("ROUTE_TYPE", (Expression)this.simple(RouteTypeEnum.PUBLISHER.toString(), RouteTypeEnum.class))).setHeader("PARTNER_ID", (Expression)this.simple(Long.toString(task.getPartner().getId()), Long.class))).setHeader("TASK_ID", (Expression)this.simple(Long.toString(task.getId()), Long.class))).setHeader("IS_ETV", (Expression)this.simple(Boolean.toString(isETV), Boolean.class))).bean((Object)this.camelLogHandler, "logInfo(*, 'Starting EPG receive')")).process((Processor)this.memoryCheckProcessor)).to("direct:fromDatabase")).bean((Object)this.job, "stepStart('" + this.storeFileStepName + "')")).process((Processor)new CompressProcessor())).to(this.createEndpoint(this.job))).process((Processor)new FileDeleter())).bean((Object)this.job, "stepEnd('" + this.storeFileStepName + "')")).bean((Object)this.camelLogHandler, "logInfo(*, 'Finished EPG receive')");
    }

    @Override
    protected String getOptionsForEndpoint(Endpoint endPoint) {
        EndpointSchemeEnum endpointType;
        StringBuffer uriOptions = new StringBuffer();
        if (StringUtils.isNotBlank((String)endPoint.getFileName())) {
            uriOptions.append("&fileName=").append(endPoint.getFileName());
        }
        if (StringUtils.isNotBlank((String)endPoint.getDoneFile())) {
            uriOptions.append("&doneFileName=").append(endPoint.getDoneFile());
        }
        if ((endpointType = endPoint.getEndpointType()) == EndpointSchemeEnum.ftp || endpointType == EndpointSchemeEnum.sftp) {
            String ftpOptions = this.changeTransferMode(endPoint, endpointType == EndpointSchemeEnum.ftp ? this.camelFtpOptions : this.camelSftpOptions);
            String errMsg = CamelFtpOptionsVerifier.verify(endpointType, ftpOptions);
            if (errMsg != null) {
                String defaultFtpOptions = endpointType == EndpointSchemeEnum.ftp ? "&maximumReconnectAttempts=0&disconnect=true&separator=UNIX" : "&maximumReconnectAttempts=0&disconnect=true&separator=UNIX";
                this.log.warn(String.format("%s. Use default option: %s ", errMsg, defaultFtpOptions));
                ftpOptions = defaultFtpOptions;
            }
            uriOptions.append(ftpOptions);
            if (StringUtils.isNotBlank((String)endPoint.getPassword())) {
                uriOptions.append("&password=").append(endPoint.getPassword());
            }
        }
        if (uriOptions.length() > 0) {
            uriOptions.deleteCharAt(0);
        }
        return uriOptions.toString();
    }

    private String changeTransferMode(Endpoint endPoint, String ftpOptions) {
        boolean binary;
        String fileName = endPoint.getFileName().toLowerCase();
        boolean bl = binary = fileName.endsWith(".gz") || fileName.endsWith(".zip");
        if (StringUtils.isBlank((String)ftpOptions)) {
            return "binary=" + String.valueOf(binary);
        }
        ftpOptions = ftpOptions + "&binary=" + String.valueOf(binary);
        return ftpOptions;
    }

    public void setExportJobRoutePolicy(ExportJobRoutePolicy routePolicy) {
        this.routePolicy = routePolicy;
    }

    public void setCamelLogHandler(CamelLogHandler camelLogHandler) {
        this.camelLogHandler = camelLogHandler;
    }

    public void setJob(IJob job) {
        this.job = job;
    }

    public void setPollStrategy(CustomPollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    @Override
    protected PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setStoreFileStepName(String storeFileStepName) {
        this.storeFileStepName = storeFileStepName;
    }

    public void setCamelFtpOptions(String camelFtpOptions) {
        this.camelFtpOptions = camelFtpOptions;
    }

    public void setCamelSftpOptions(String camelSftpOptions) {
        this.camelSftpOptions = camelSftpOptions;
    }

    public void setMetadataManager(IEPGMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    public void setMemoryCheckProcessor(MemoryCheckProcessor memoryCheckProcessor) {
        this.memoryCheckProcessor = memoryCheckProcessor;
    }
}

