/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routebuilder;

import com.ericsson.cms.epgmgmt.camel.processor.FileNameMatcherProcessor;
import com.ericsson.cms.epgmgmt.camel.processor.FolderDeleter;
import com.ericsson.cms.epgmgmt.camel.processor.IngestTaskHeaderProcessor;
import com.ericsson.cms.epgmgmt.camel.processor.MemoryCheckProcessor;
import com.ericsson.cms.epgmgmt.camel.routebuilder.BaseRouteBuilder;
import com.ericsson.cms.epgmgmt.camel.routebuilder.CamelFtpOptionsVerifier;
import com.ericsson.cms.epgmgmt.camel.routepolicy.IngestJobPollStrategy;
import com.ericsson.cms.epgmgmt.camel.routepolicy.IngestJobRoutePolicy;
import com.ericsson.cms.epgmgmt.entity.Endpoint;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.job.JobAggregateStrategy;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.util.ConfigProperties;
import com.ericsson.cms.epgmgmt.util.RegexUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import java.net.URISyntaxException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.commons.lang.StringUtils;

public class IngestJobRouteBuilder
extends BaseRouteBuilder {
    private String camelFtpOptions;
    private String camelSftpOptions;
    private IngestJobRoutePolicy routePolicy;
    private IngestJobPollStrategy pollStrategy;
    private FileNameMatcherProcessor fileNameMatcherProcessor;
    private MemoryCheckProcessor memoryCheckProcessor;
    private IJob job;

    public void configure() throws URISyntaxException {
        Task task = this.job.getTask();
        String tmpFolderName = ConfigProperties.getWorkFolderForIngestTask(task);
        ((ChoiceDefinition)((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)((RouteDefinition)this.from(this.createEndpoint(this.job)).routePolicy(new RoutePolicy[]{this.routePolicy}).routeId(RouteBuilderUtils.getRouteId(task)).to("file://" + tmpFolderName)).aggregate((Expression)this.constant(true), (AggregationStrategy)new JobAggregateStrategy()).completionFromBatchConsumer().process((Processor)new FolderDeleter(tmpFolderName))).process((Processor)new IngestTaskHeaderProcessor(task))).process((Processor)this.fileNameMatcherProcessor)).choice().when(this.header("Lack_File").isEqualTo((Object)Boolean.FALSE)).process((Processor)this.memoryCheckProcessor)).to("direct:ftpToDatabase");
    }

    @Override
    protected String getOptionsForEndpoint(Endpoint endPoint) {
        StringBuilder uriOptions = new StringBuilder();
        uriOptions.append("consumer.delay=999999&initialDelay=0");
        if (StringUtils.isNotBlank((String)endPoint.getFileName())) {
            uriOptions.append("&recursive=true");
            if (endPoint.getFileName().contains("*")) {
                uriOptions.append("&include=").append(RegexUtil.toJavaStyleRegex(endPoint.getFileName()));
            } else {
                uriOptions.append("&fileName=").append(endPoint.getFileName());
            }
            if (!StringUtils.isBlank((String)endPoint.getDoneFile())) {
                uriOptions.append("&doneFileName=").append(endPoint.getDoneFile());
            }
        }
        String ftpOptions = this.camelSftpOptions;
        EndpointSchemeEnum enpointScheme = endPoint.getEndpointType();
        switch (enpointScheme) {
            case ftp: {
                ftpOptions = this.camelFtpOptions;
            }
            case sftp: {
                String errMsg = CamelFtpOptionsVerifier.verify(enpointScheme, ftpOptions);
                if (errMsg != null) {
                    String defaultFtpOptions = enpointScheme == EndpointSchemeEnum.ftp ? "&throwExceptionOnConnectFailed=true&maximumReconnectAttempts=0&disconnect=true&noop=false&binary=true&delete=false&separator=UNIX" : "&throwExceptionOnConnectFailed=true&maximumReconnectAttempts=0&disconnect=true&noop=false&binary=true&delete=false&separator=UNIX";
                    this.log.warn(String.format("%s. Use default option: %s ", errMsg, defaultFtpOptions));
                    ftpOptions = defaultFtpOptions;
                }
                uriOptions.append(ftpOptions);
                if (StringUtils.isNotBlank((String)endPoint.getPassword())) {
                    uriOptions.append("&password=").append(endPoint.getPassword());
                }
                String tempFolder = ConfigProperties.getFtpTempFolderForProvider();
                uriOptions.append("&localWorkDirectory=").append(tempFolder);
                break;
            }
            default: {
                uriOptions.append("&delete=true");
            }
        }
        return uriOptions.toString();
    }

    public IngestJobRoutePolicy getTaskRoutePolicy() {
        return this.routePolicy;
    }

    public void setTaskRoutePolicy(IngestJobRoutePolicy routePolicy) {
        this.routePolicy = routePolicy;
    }

    public void setJob(IJob job) {
        this.job = job;
    }

    public void setPollStrategy(IngestJobPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    @Override
    protected PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setCamelFtpOptions(String camelFtpOptions) {
        this.camelFtpOptions = camelFtpOptions;
    }

    public void setCamelSftpOptions(String camelSftpOptions) {
        this.camelSftpOptions = camelSftpOptions;
    }

    public void setFileNameMatcherProcessor(FileNameMatcherProcessor fileNameMatcherProcessor) {
        this.fileNameMatcherProcessor = fileNameMatcherProcessor;
    }

    public void setMemoryCheckProcessor(MemoryCheckProcessor memoryCheckProcessor) {
        this.memoryCheckProcessor = memoryCheckProcessor;
    }
}

