/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routebuilder;

import com.ericsson.cms.epgmgmt.camel.handler.CamelLogHandler;
import com.ericsson.cms.epgmgmt.camel.processor.FileNameMatcherProcessor;
import com.ericsson.cms.epgmgmt.camel.processor.MemoryCheckProcessor;
import com.ericsson.cms.epgmgmt.camel.routebuilder.BaseRouteBuilder;
import com.ericsson.cms.epgmgmt.camel.routebuilder.ExportJobRouteBuilder;
import com.ericsson.cms.epgmgmt.camel.routebuilder.IngestJobRouteBuilder;
import com.ericsson.cms.epgmgmt.camel.routepolicy.CustomPollingConsumerPollStrategy;
import com.ericsson.cms.epgmgmt.camel.routepolicy.ExportJobRoutePolicy;
import com.ericsson.cms.epgmgmt.camel.routepolicy.IngestJobPollStrategy;
import com.ericsson.cms.epgmgmt.camel.routepolicy.IngestJobRoutePolicy;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import java.util.Map;
import org.apache.camel.builder.RouteBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class RouteFactory {
    private IAlarmActivityLogManager alarmActivityLogManager;
    private ITaskJobExecutor jobExecutor;
    private String retrieveFileStepName;
    private CamelLogHandler camelLogHandler;
    private String storeFileStepName;
    private String ingestFtpOptions;
    private String ingestSftpOptions;
    private String exportFtpOptions;
    private String exportSftpOptions;
    private Map<String, String> errorMap;
    private MemoryCheckProcessor memoryCheckProcessor;
    @Autowired
    private IEPGMetadataManager metadataManager;

    public RouteBuilder createTaskJobRoute(IJob job) {
        switch (job.getTask().getType()) {
            case INGEST: {
                return this.createIngestRouteBuilder(job);
            }
        }
        return this.createExportRouteBuilder(job);
    }

    private IngestJobRouteBuilder createIngestRouteBuilder(IJob job) {
        IngestJobRoutePolicy routePolicy = new IngestJobRoutePolicy();
        routePolicy.setApplicationLogger(this.alarmActivityLogManager);
        routePolicy.setRetreiveFileStepName(this.retrieveFileStepName);
        routePolicy.setJobExecutor(this.jobExecutor);
        routePolicy.setJob((Job)job);
        routePolicy.setErrorMap(this.errorMap);
        IngestJobPollStrategy pollStrategy = new IngestJobPollStrategy((Job)job);
        pollStrategy.setActivityLogManager(this.alarmActivityLogManager);
        pollStrategy.setRetreiveFileStepName(this.retrieveFileStepName);
        pollStrategy.setJobExecutor(this.jobExecutor);
        IngestJobRouteBuilder builder = new IngestJobRouteBuilder();
        builder.setJob(job);
        builder.setPollStrategy(pollStrategy);
        builder.setTaskRoutePolicy(routePolicy);
        FileNameMatcherProcessor fileNameMatcherProcessor = new FileNameMatcherProcessor();
        builder.setFileNameMatcherProcessor(fileNameMatcherProcessor);
        builder.setCamelFtpOptions(this.ingestFtpOptions);
        builder.setCamelSftpOptions(this.ingestSftpOptions);
        builder.setMemoryCheckProcessor(this.memoryCheckProcessor);
        return builder;
    }

    private BaseRouteBuilder createExportRouteBuilder(IJob job) {
        ExportJobRoutePolicy routePolicy = new ExportJobRoutePolicy();
        routePolicy.setJob((Job)job);
        routePolicy.setApplicationLogger(this.alarmActivityLogManager);
        routePolicy.setJobExecutor(this.jobExecutor);
        routePolicy.setErrorMap(this.errorMap);
        CustomPollingConsumerPollStrategy pollStrategy = new CustomPollingConsumerPollStrategy((Job)job);
        pollStrategy.setActivityLogManager(this.alarmActivityLogManager);
        pollStrategy.setJobExecutor(this.jobExecutor);
        ExportJobRouteBuilder builder = new ExportJobRouteBuilder();
        builder.setJob(job);
        builder.setPollStrategy(pollStrategy);
        builder.setExportJobRoutePolicy(routePolicy);
        builder.setCamelLogHandler(this.camelLogHandler);
        builder.setStoreFileStepName(this.storeFileStepName);
        builder.setCamelFtpOptions(this.exportFtpOptions);
        builder.setCamelSftpOptions(this.exportSftpOptions);
        builder.setMetadataManager(this.metadataManager);
        builder.setMemoryCheckProcessor(this.memoryCheckProcessor);
        return builder;
    }

    public IAlarmActivityLogManager getAlarmActivityLogManager() {
        return this.alarmActivityLogManager;
    }

    @Autowired
    public void setAlarmActivityLogManager(IAlarmActivityLogManager alarmActivityLogManager) {
        this.alarmActivityLogManager = alarmActivityLogManager;
    }

    @Autowired
    public void setJobExecutor(ITaskJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setRetrieveFileStepName(String retrieveFileStepName) {
        this.retrieveFileStepName = retrieveFileStepName;
    }

    public void setStoreFileStepName(String storeFileStepName) {
        this.storeFileStepName = storeFileStepName;
    }

    public void setCamelLogHandler(CamelLogHandler camelLogHandler) {
        this.camelLogHandler = camelLogHandler;
    }

    public String getIngestFtpOptions() {
        return this.ingestFtpOptions;
    }

    public void setIngestFtpOptions(String ingestFtpOptions) {
        this.ingestFtpOptions = ingestFtpOptions;
    }

    public String getIngestSftpOptions() {
        return this.ingestSftpOptions;
    }

    public void setIngestSftpOptions(String ingestSftpOptions) {
        this.ingestSftpOptions = ingestSftpOptions;
    }

    @Required
    public String getExportFtpOptions() {
        return this.exportFtpOptions;
    }

    @Required
    public void setExportFtpOptions(String exportFtpOptions) {
        this.exportFtpOptions = exportFtpOptions;
    }

    @Required
    public String getExportSftpOptions() {
        return this.exportSftpOptions;
    }

    @Required
    public void setExportSftpOptions(String exportSftpOptions) {
        this.exportSftpOptions = exportSftpOptions;
    }

    public void setErrorMap(Map<String, String> errorMap) {
        this.errorMap = errorMap;
    }

    @Autowired
    public void setMemoryCheckProcessor(MemoryCheckProcessor memoryCheckProcessor) {
        this.memoryCheckProcessor = memoryCheckProcessor;
    }
}

