/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routepolicy;

import com.ericsson.cms.epgmgmt.camel.FtpConsumerExt;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPollingConsumerPollStrategy
implements PollingConsumerPollStrategy {
    private static final Logger LOGGER = Logger.getLogger(CustomPollingConsumerPollStrategy.class);
    private IAlarmActivityLogManager activityLogManager;
    private ITaskJobExecutor jobExecutor;
    private final Job job;

    public CustomPollingConsumerPollStrategy(Job job) {
        this.job = job;
    }

    public boolean begin(final Consumer consumer, final Endpoint endpoint) {
        if (consumer instanceof FtpConsumerExt) {
            ((FtpConsumerExt)consumer).setTask(this.job.getTask());
        }
        if (consumer instanceof GenericFileConsumer) {
            GenericFileConsumer con = (GenericFileConsumer)consumer;
            con.setExceptionHandler(new ExceptionHandler(){

                public void handleException(Throwable exception) {
                    CustomPollingConsumerPollStrategy.this.handleExeption(consumer, endpoint, "", exception);
                }

                public void handleException(String message, Throwable exception) {
                    CustomPollingConsumerPollStrategy.this.handleExeption(consumer, endpoint, message, exception);
                }

                public void handleException(String message, Exchange exchange, Throwable exception) {
                    CustomPollingConsumerPollStrategy.this.handleExeption(consumer, endpoint, message, exception);
                }
            });
        }
        LOGGER.trace((Object)("Starting to poll endpoint -" + endpoint.getEndpointUri()));
        return true;
    }

    private void handleExeption(Consumer consumer, Endpoint endpoint, String message, Throwable th) {
        String remark = "Failed to retrieve files ";
        LOGGER.error((Object)message, th);
        this.getActivityLogManager().log(PluginLogSeverity.ERROR, PluginLogComponent.WORKFLOW, remark, this.job.getTask().getPartner().getId(), this.job.getTask().getPartner().getPartnerType().toString());
        this.stopConsumer(consumer);
        this.job.getMessages().add(new MessageEntry(EmailAlertLevelEnum.ERROR, "", remark, PluginLogComponent.WORKFLOW));
        this.job.getJobEntity().setErrorMessage("ERR_RETRIEVE_FILE");
        this.job.setStatus(JobStatusEnum.FAILDED);
        this.getJobExecutor().endJob((IJob)this.job);
    }

    public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
        LOGGER.trace((Object)("Completed poll to endpoint  " + endpoint.getEndpointUri()));
    }

    protected void stopConsumer(Consumer consumer) {
        try {
            consumer.stop();
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Can't stop retriving file services for task " + this.job.getTask().getName()), (Throwable)e);
        }
    }

    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) {
        LOGGER.debug((Object)("Failed to poll endpoint " + endpoint.getEndpointUri() + " No of attempts -" + retryCounter));
        LOGGER.error((Object)cause.getMessage());
        if (retryCounter < 2) {
            LOGGER.debug((Object)" Will retry ");
            return true;
        }
        this.handleExeption(consumer, endpoint, "", cause);
        return false;
    }

    public ITaskJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Autowired
    public void setJobExecutor(ITaskJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public IAlarmActivityLogManager getActivityLogManager() {
        return this.activityLogManager;
    }

    @Autowired
    public void setActivityLogManager(IAlarmActivityLogManager activityLogManager) {
        this.activityLogManager = activityLogManager;
    }

    public Job getJob() {
        return this.job;
    }
}

