/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routepolicy;

import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportJobRoutePolicy
extends RoutePolicySupport {
    private IAlarmActivityLogManager applicationLogger;
    private ITaskJobExecutor jobExecutor;
    private Job job;
    private Map<String, String> errorMap;

    public void onExchangeBegin(Route route, Exchange exchange) {
        Partner partner = this.job.getTask().getPartner();
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PUBLISH, "Starting export ", partner.getId(), partner.getPartnerType().toString());
        exchange.setProperty("EXCHANGE_JOB_PROPERTY", (Object)this.job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExchangeDone(Route route, Exchange exchange) {
        try {
            String remark = this.job.getJobEntity().getErrorMessage();
            if (this.job.isCanceled()) {
                this.job.setStatus(JobStatusEnum.CANCELD);
                remark = "Run Failed - The job has been canceled";
                this.job.getJobEntity().setErrorMessage("ERR_CANCELLED");
            } else if (exchange.getProperty("CamelExceptionCaught") != null) {
                this.job.setStatus(JobStatusEnum.FAILDED);
                remark = this.getErrorMessage((Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class));
                this.job.getJobEntity().setErrorMessage(remark);
                remark = "Run Failed - " + remark;
            }
            String tmp = this.job.getJobEntity().getErrorMessage();
            if (tmp != null) {
                for (Map.Entry<String, String> entry : this.errorMap.entrySet()) {
                    if (tmp.indexOf(entry.getKey()) == -1) continue;
                    this.job.getJobEntity().setErrorMessage(entry.getValue());
                    break;
                }
            }
            Partner partner = this.job.getTask().getPartner();
            if (this.job.getJobEntity().getStatus() == JobStatusEnum.CANCELD) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.PUBLISH, remark, partner.getId(), partner.getPartnerType().toString());
            } else if (this.job.getJobEntity().getStatus() == JobStatusEnum.FAILDED) {
                this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PUBLISH, remark, partner.getId(), partner.getPartnerType().toString());
            } else {
                this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PUBLISH, "Run successfully", partner.getId(), partner.getPartnerType().toString());
            }
        }
        finally {
            this.jobExecutor.endJob((IJob)this.job);
        }
    }

    private String getErrorMessage(Throwable th) {
        Throwable exception = ExceptionUtils.getRootCause((Throwable)th);
        String msg = exception == null ? th.getMessage() : exception.getMessage();
        return msg == null ? "" : msg;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    @Autowired
    public void setApplicationLogger(IAlarmActivityLogManager applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Autowired
    public void setJobExecutor(ITaskJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setErrorMap(Map<String, String> errorMap) {
        this.errorMap = errorMap;
    }
}

