/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routepolicy;

import com.ericsson.cms.epgmgmt.camel.routepolicy.CustomPollingConsumerPollStrategy;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.service.ActivityLogger;
import com.ericsson.cms.epgmgmt.service.IJob;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IngestJobPollStrategy
extends CustomPollingConsumerPollStrategy {
    private static final Logger LOGGER = Logger.getLogger(IngestJobPollStrategy.class);
    private String retrieveFileStepName;

    public IngestJobPollStrategy(Job job) {
        super(job);
    }

    @Override
    public boolean begin(Consumer consumer, Endpoint endpoint) {
        String includePattern;
        if (!super.begin(consumer, endpoint)) {
            return false;
        }
        if (endpoint instanceof GenericFileEndpoint && !StringUtils.isBlank((String)(includePattern = ((GenericFileEndpoint)endpoint).getInclude()))) {
            Exchange dummy = endpoint.createExchange();
            Expression expression = ExpressionBuilder.simpleExpression((String)includePattern);
            String newIncludePattern = (String)expression.evaluate(dummy, String.class);
            LOGGER.trace((Object)(" Changing include pattern to " + newIncludePattern + " from " + includePattern));
            ((GenericFileEndpoint)endpoint).setInclude(newIncludePattern);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
        super.commit(consumer, endpoint, polledMessages);
        if (polledMessages == 0) {
            try {
                Partner partner = this.getJob().getTask().getPartner();
                String infoStr = String.format("No files found for ingest task[id=%d,name=%s].The current ingestion is canceled.", this.getJob().getTask().getId(), this.getJob().getTask().getName(), partner.getId(), partner.getPartnerType().toString());
                ActivityLogger.getInstance().log(PluginLogSeverity.WARNING, PluginLogComponent.WORKFLOW, infoStr, partner.getId(), PartnerTypeEnum.Provider.toString());
                LOGGER.warn((Object)infoStr);
                this.getJob().getMessages().add(new MessageEntry(EmailAlertLevelEnum.WARNING, "", infoStr, PluginLogComponent.WORKFLOW));
                this.stopConsumer(consumer);
                this.getJob().getJobEntity().setErrorMessage("ERR_NO_FILES");
                this.getJob().setStatus(JobStatusEnum.FAILDED);
                this.getJob().getContext().put("Lack_File", Boolean.TRUE);
                this.getJob().stepStart(this.retrieveFileStepName);
                this.getJob().stepError(infoStr);
            }
            finally {
                this.getJobExecutor().endJob((IJob)this.getJob());
            }
        }
    }

    public void setRetreiveFileStepName(String retrieveFileStepName) {
        this.retrieveFileStepName = retrieveFileStepName;
    }
}

