/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel.routepolicy;

import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class IngestJobRoutePolicy
extends RoutePolicySupport {
    private static Logger logger = Logger.getLogger(IngestJobRoutePolicy.class);
    private IAlarmActivityLogManager applicationLogger;
    private String retreiveFileStepName;
    private ITaskJobExecutor jobExecutor;
    private Job job;
    private Map<String, String> errorMap;

    public void onExchangeBegin(Route route, Exchange exchange) {
        logger.info((Object)(" exchange start:" + Thread.currentThread().getName()));
        String message = "Prepare to ingestion, start to retrieve file :[" + exchange.getIn() + "]";
        logger.info((Object)message);
        Partner partner = this.job.getTask().getPartner();
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.INGEST, message, partner.getId(), partner.getPartnerType().toString());
        this.processJob(exchange);
    }

    private void processJob(Exchange exchange) {
        int batchSize = (Integer)exchange.getProperty("CamelBatchSize", (Object)0, Integer.class);
        int batchIndex = (Integer)exchange.getProperty("CamelBatchIndex", (Object)0, Integer.class);
        if (batchSize == 0 || batchIndex == 0) {
            this.job.stepStart(this.retreiveFileStepName, null);
        }
        this.job.setCurStepProgress((int)((float)batchIndex * 100.0f / (float)batchSize));
        exchange.setProperty("EXCHANGE_JOB_PROPERTY", (Object)this.job);
        if (((Boolean)exchange.getProperty("CamelBatchComplete", (Object)true, Boolean.class)).booleanValue()) {
            this.job.stepEnd(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExchangeDone(Route route, Exchange exchange) {
        String remark = "Run Failed - " + this.job.getJobEntity().getErrorMessage();
        if (this.isBatchComplete(exchange) || exchange.isFailed() || this.job.isCanceled()) {
            if (this.job.isCanceled()) {
                this.job.setStatus(JobStatusEnum.CANCELD);
                this.job.getJobEntity().setErrorMessage("ERR_CANCELLED");
                remark = "Run Failed - The job has been canceled.";
            } else if (exchange.getProperty("CamelExceptionCaught") != null) {
                this.job.setStatus(JobStatusEnum.FAILDED);
                remark = this.getErrorMessage((Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class));
                this.job.getJobEntity().setErrorMessage(remark);
                remark = "Run Failed - " + remark;
            }
            String tmp = this.job.getJobEntity().getErrorMessage();
            if (tmp != null) {
                for (Map.Entry<String, String> entry : this.errorMap.entrySet()) {
                    if (tmp.indexOf(entry.getKey()) == -1) continue;
                    this.job.getJobEntity().setErrorMessage(entry.getValue());
                }
            }
            try {
                Partner partner = this.job.getTask().getPartner();
                if (this.job.getJobEntity().getStatus() == JobStatusEnum.CANCELD) {
                    this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.INGEST, remark, partner.getId(), partner.getPartnerType().toString());
                } else if (this.job.getJobEntity().getStatus() == JobStatusEnum.FAILDED) {
                    this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.INGEST, remark, partner.getId(), partner.getPartnerType().toString());
                } else {
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.INGEST, "Run successfully", partner.getId(), partner.getPartnerType().toString());
                }
            }
            finally {
                this.jobExecutor.endJob((IJob)this.job);
            }
        }
    }

    protected boolean isBatchComplete(Exchange exchange) {
        return (Boolean)exchange.getProperty("CamelBatchComplete", (Object)Boolean.FALSE, Boolean.class);
    }

    private String getErrorMessage(Throwable th) {
        Throwable exception = ExceptionUtils.getRootCause((Throwable)th);
        String msg = exception == null ? th.getMessage() : exception.getMessage();
        return msg == null ? "" : msg;
    }

    public IAlarmActivityLogManager getApplicationLogger() {
        return this.applicationLogger;
    }

    public void setApplicationLogger(IAlarmActivityLogManager applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public String getRetreiveFileStepName() {
        return this.retreiveFileStepName;
    }

    public void setRetreiveFileStepName(String retreiveFileStepName) {
        this.retreiveFileStepName = retreiveFileStepName;
    }

    public void setJobExecutor(ITaskJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setErrorMap(Map<String, String> errorMap) {
        this.errorMap = errorMap;
    }
}

