/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.cluster;

import com.ericsson.cms.epgmgmt.cluster.message.TaskJobTopicMessage;
import com.ericsson.cms.epgmgmt.cluster.message.TaskTopicMessage;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MessageListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;

public class HazelcastManager {
    private static final int SLEEP_TIME = 200;
    private static final int RETRY_TIMES = 5;
    public static final String TOPIC_EPG_TASK = "epg-task";
    public static final String TOPIC_EPG_TASKJOB = "epg-taskjob";
    public static final String EPG_TOKEN_MAP_KEY = "epg-token";
    public static final String EPG_JOB_DATA_MAP_KEY = "epg-job-data";
    public static final long DEFAULT_TIMEOUT = 7200L;
    private static Logger logger = Logger.getLogger(HazelcastManager.class);
    private HazelcastInstance instance;
    private Member localServer;
    private ITopic<TaskTopicMessage> taskTopic;
    private ITopic<TaskJobTopicMessage> taskJobTopic;
    private List<MessageListener<TaskTopicMessage>> taskTopicListeners = new ArrayList<MessageListener<TaskTopicMessage>>();
    private List<MessageListener<TaskJobTopicMessage>> taskJobTopicListeners = new ArrayList<MessageListener<TaskJobTopicMessage>>();

    public HazelcastManager() {
        this.instance = Hazelcast.getDefaultInstance();
        this.localServer = this.instance.getCluster().getLocalMember();
    }

    public void setHazelCastInstance(HazelcastInstance instance) {
        this.instance = instance;
        this.localServer = instance.getCluster().getLocalMember();
    }

    public boolean acquireToken(String key) {
        return this.acquireToken(key, 7200L);
    }

    public boolean acquireToken(String key, long expireTime) {
        boolean success = this.lockToken(key, expireTime, this.localServer);
        if (!success) {
            int retry = 5;
            for (int i = 0; i < retry; ++i) {
                boolean crashed;
                Member remoteServer = (Member)this.instance.getMap(EPG_TOKEN_MAP_KEY).get((Object)key);
                boolean bl = crashed = !this.isRemoteSeverWork(remoteServer);
                if (crashed) {
                    if (remoteServer != null) {
                        logger.warn((Object)"\tthe remote server is crashed");
                        this.instance.getMap(EPG_TOKEN_MAP_KEY).remove((Object)key, (Object)remoteServer);
                    }
                    if (success = this.lockToken(key, expireTime, this.localServer)) break;
                }
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"getToken", (Throwable)e);
                }
            }
        }
        return success;
    }

    public void releaseToken(String key) {
        this.instance.getMap(EPG_TOKEN_MAP_KEY).remove((Object)key, (Object)this.localServer);
    }

    private boolean lockToken(String key, long expireTime, Member selfServer) {
        Member old = (Member)this.instance.getMap(EPG_TOKEN_MAP_KEY).putIfAbsent((Object)key, (Object)selfServer, expireTime, TimeUnit.SECONDS);
        if (old != null && old.equals(this.localServer)) {
            this.instance.getMap(EPG_TOKEN_MAP_KEY).put((Object)key, (Object)selfServer, expireTime, TimeUnit.SECONDS);
            return true;
        }
        return old == null;
    }

    public boolean isRemoteSeverWork(Member remoteServer) {
        Set members = this.instance.getCluster().getMembers();
        boolean find = false;
        for (Member m : members) {
            if (!m.equals(remoteServer)) continue;
            find = true;
            break;
        }
        return find;
    }

    public void setTaskTopicListeners(List<MessageListener<TaskTopicMessage>> taskTopicListeners) {
        this.taskTopicListeners = taskTopicListeners;
    }

    public void setTaskJobTopicListeners(List<MessageListener<TaskJobTopicMessage>> taskJobTopicListeners) {
        this.taskJobTopicListeners = taskJobTopicListeners;
    }

    @PostConstruct
    public void start() {
        this.taskTopic = this.initTopic(TOPIC_EPG_TASK, this.taskTopicListeners);
        this.taskJobTopic = this.initTopic(TOPIC_EPG_TASKJOB, this.taskJobTopicListeners);
    }

    private <T> ITopic<T> initTopic(String topicName, List<MessageListener<T>> listeners) {
        ITopic topic = this.instance.getTopic(topicName);
        if (listeners != null) {
            for (MessageListener<T> l : listeners) {
                topic.addMessageListener(l);
            }
        }
        return topic;
    }

    @PreDestroy
    public void stop() {
        if (this.instance.getLifecycleService().isRunning()) {
            this.destroyTopic(this.taskTopic, this.taskTopicListeners);
            this.destroyTopic(this.taskJobTopic, this.taskJobTopicListeners);
        }
    }

    private <T> void destroyTopic(ITopic<T> topic, List<MessageListener<T>> listeners) {
        if (listeners != null) {
            for (MessageListener<T> l : listeners) {
                topic.removeMessageListener(l);
            }
        }
        topic.destroy();
    }

    public boolean isRemoteServerUp(String ip, int port) {
        Set members = this.instance.getCluster().getMembers();
        boolean find = false;
        for (Member m : members) {
            if (!m.getInetSocketAddress().getAddress().getHostAddress().equals(ip) || m.getInetSocketAddress().getPort() != port) continue;
            find = true;
            break;
        }
        return find;
    }

    public ITopic<TaskTopicMessage> getTaskTopic() {
        return this.taskTopic;
    }

    public ITopic<TaskJobTopicMessage> getTaskJobTopic() {
        return this.taskJobTopic;
    }

    public IMap<String, Object> getJobDataMap() {
        return this.instance.getMap(EPG_JOB_DATA_MAP_KEY);
    }

    public IMap<String, Object> getTokenMap() {
        return this.instance.getMap(EPG_TOKEN_MAP_KEY);
    }

    public Member getLocalServer() {
        return this.localServer;
    }

    public boolean isActive() {
        return this.instance != null && this.instance.getLifecycleService().isRunning();
    }
}

