/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.cluster.accessor;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.cluster.data.JobStatusData;
import com.ericsson.cms.epgmgmt.cluster.util.KeyUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class JobDataMapAccessor {
    private HazelcastManager hazelcastManager;

    public void publishJobStatus(JobStatusData jobStatus) {
        this.hazelcastManager.getJobDataMap().put((Object)KeyUtil.getJobStatusKey(jobStatus.getTaskId()), (Object)jobStatus, 7200L, TimeUnit.SECONDS);
    }

    public void eraseJobStatus(long taskId) {
        this.hazelcastManager.getJobDataMap().remove((Object)KeyUtil.getJobStatusKey(taskId));
    }

    public JobStatusData getJobStatus(long taskId) {
        return (JobStatusData)this.hazelcastManager.getJobDataMap().get((Object)KeyUtil.getJobStatusKey(taskId));
    }

    public void putData(String key, Object data, long expireTime) {
        this.hazelcastManager.getJobDataMap().put((Object)key, data, expireTime, TimeUnit.SECONDS);
    }

    public void putData(String key, Object data) {
        this.putData(key, data, 7200L);
    }

    public void removeData(String key) {
        this.hazelcastManager.getJobDataMap().remove((Object)key);
    }

    public <T> T getData(String key, Class<T> type) {
        return (T)this.hazelcastManager.getJobDataMap().get((Object)key);
    }

    @Autowired
    public void setHazelcastManager(HazelcastManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }
}

