/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.cluster.data;

import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.job.Job;
import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public class JobStatusData
implements DataSerializable {
    private static final long serialVersionUID = -7247756824120590395L;
    private long jobId;
    private long taskId;
    private JobStatusEnum jobStatus;
    private int jobProgress;
    private String stepName;
    private int stepProgress;
    private Date triggerTime;
    private TaskTriggerTypeEnum triggerType;
    private Member member;

    public JobStatusData() {
    }

    public JobStatusData(Job job, Member member) {
        this.jobId = job.getId();
        this.taskId = job.getTask().getId();
        this.jobStatus = job.getJobEntity().getStatus();
        this.jobProgress = job.getProgress();
        if (job.getCurrentStep() != null) {
            this.stepName = job.getCurrentStep().getStepName();
            this.stepProgress = job.getCurrentStep().getProgresss();
        }
        this.triggerTime = (Date)job.getContext().get("trigger.time");
        this.triggerType = job.getTask().getTriggerType();
        this.member = member;
    }

    public long getJobId() {
        return this.jobId;
    }

    public JobStatusData setJobId(long jobId) {
        this.jobId = jobId;
        return this;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public JobStatusData setTaskId(long taskId) {
        this.taskId = taskId;
        return this;
    }

    public JobStatusEnum getJobStatus() {
        return this.jobStatus;
    }

    public JobStatusData setJobStatus(JobStatusEnum jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    public int getJobProgress() {
        return this.jobProgress;
    }

    public JobStatusData setJobProgress(int jobProgress) {
        this.jobProgress = jobProgress;
        return this;
    }

    public String getStepName() {
        return this.stepName;
    }

    public JobStatusData setStepName(String stepName) {
        this.stepName = stepName;
        return this;
    }

    public int getStepProgress() {
        return this.stepProgress;
    }

    public JobStatusData setStepProgress(int stepProgress) {
        this.stepProgress = stepProgress;
        return this;
    }

    public Date getTriggerTime() {
        return this.triggerTime;
    }

    public JobStatusData setTriggerTime(Date triggerTime) {
        this.triggerTime = triggerTime;
        return this;
    }

    public TaskTriggerTypeEnum getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TaskTriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
    }

    public void readData(DataInput in) throws IOException {
        this.jobId = in.readLong();
        this.taskId = in.readLong();
        if (in.readBoolean()) {
            this.jobStatus = JobStatusEnum.valueOf((String)in.readUTF());
        }
        this.jobProgress = in.readInt();
        if (in.readBoolean()) {
            this.stepName = in.readUTF();
        }
        this.stepProgress = in.readInt();
        if (in.readBoolean()) {
            this.triggerTime = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.triggerType = TaskTriggerTypeEnum.valueOf((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.member = new MemberImpl();
            this.member.readData(in);
        }
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.taskId);
        out.writeBoolean(this.jobStatus != null);
        if (this.jobStatus != null) {
            out.writeUTF(this.jobStatus.name());
        }
        out.writeInt(this.jobProgress);
        out.writeBoolean(this.stepName != null);
        if (this.stepName != null) {
            out.writeUTF(this.stepName);
        }
        out.writeInt(this.stepProgress);
        out.writeBoolean(this.triggerTime != null);
        if (this.triggerTime != null) {
            out.writeLong(this.triggerTime.getTime());
        }
        out.writeBoolean(this.triggerType != null);
        if (this.triggerType != null) {
            out.writeUTF(this.triggerType.name());
        }
        out.writeBoolean(this.member != null);
        if (this.member != null) {
            this.member.writeData(out);
        }
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }
}

