/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.cluster.listener;

import com.ericsson.cms.epgmgmt.cluster.message.TaskTopicMessage;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.service.ScheduleException;
import com.ericsson.cms.epgmgmt.service.TaskJobScheduler;
import com.hazelcast.core.MessageListener;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskTopicListener
implements MessageListener<TaskTopicMessage> {
    private static Logger logger = Logger.getLogger(TaskTopicListener.class);
    private TaskJobScheduler taskJobScheduler;
    private ITaskJobExecutor taskJobExecutor;
    private ITaskManager taskManager;

    public void onMessage(TaskTopicMessage message) {
        switch (message.getOperationType()) {
            case CREATE: {
                this.doCreate(message.getTaskId());
                break;
            }
            case UPDATE: {
                this.doUpdate(message.getTaskId());
                break;
            }
            case DELETE: {
                this.doDelete(message.getTaskId());
                break;
            }
            default: {
                logger.warn((Object)("Unknow operation type: " + message.getOperationType()));
            }
        }
    }

    private void doCreate(long taskId) {
        Task task = this.taskManager.getTask(taskId);
        if (task == null) {
            logger.warn((Object)("Cannot find task[" + taskId + "]"));
            return;
        }
        if (task.isEnabled()) {
            this.taskJobScheduler.scheduleTask(task);
        }
    }

    private void doUpdate(long taskId) {
        Task task = this.taskManager.getTask(taskId);
        if (task == null) {
            logger.warn((Object)("Cannot find task[" + taskId + "]"));
            return;
        }
        try {
            this.taskJobScheduler.stopScheduleTask(taskId);
            this.taskJobExecutor.stopLocalJobForTask(taskId);
        }
        catch (ScheduleException e) {
            logger.error((Object)"Can't stop the task scheduler", (Throwable)e);
        }
        if (task.isEnabled() && !task.isManual()) {
            this.taskJobScheduler.scheduleTask(task);
        }
    }

    private void doDelete(long taskId) {
        try {
            this.taskJobScheduler.stopScheduleTask(taskId);
            this.taskJobExecutor.stopLocalJobForTask(taskId);
        }
        catch (ScheduleException e) {
            logger.error((Object)"Can't stop the task scheduler", (Throwable)e);
        }
    }

    @Autowired
    public void setTaskJobScheduler(TaskJobScheduler taskJobScheduler) {
        this.taskJobScheduler = taskJobScheduler;
    }

    @Autowired
    public void setTaskJobExecutor(ITaskJobExecutor taskJobExecutor) {
        this.taskJobExecutor = taskJobExecutor;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }
}

