/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.cluster.util;

import com.ericsson.cms.epgmgmt.cluster.data.JobStatusData;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.util.Date;

public final class KeyUtil {
    private static final int INITIAL_CAPACITY = 50;
    private static final String DELIMITER = "-";
    public static final String PREFIX = "epg";
    public static final String KEY_JOB_STATUS = "job-status";
    private static final String TASK_ID_PREFIX = "task";
    private static final String PARTNER_ID_PREFIX = "partner";
    private static final String RECOVER_PREFIX = "recover-job";

    private KeyUtil() {
    }

    public static String getJobStatusKey(long taskId) {
        return new StringBuilder(50).append(PREFIX).append(DELIMITER).append(KEY_JOB_STATUS).append(DELIMITER).append(taskId).toString();
    }

    public static String getJobTokenKey(long taskId, Date triggerTime) {
        StringBuilder builder = new StringBuilder(50).append(PREFIX).append(DELIMITER).append(TASK_ID_PREFIX).append(DELIMITER).append(taskId);
        if (triggerTime != null) {
            builder.append(DELIMITER).append(CalendarUtil.formatString((Date)triggerTime, (String)"yyyy-MM-dd HH:mm"));
        }
        return builder.toString();
    }

    public static String getJobTokenKey(JobStatusData jobStatusData) {
        return KeyUtil.getJobTokenKey(jobStatusData.getTaskId(), jobStatusData.getTriggerType() != TaskTriggerTypeEnum.MANUAL && jobStatusData.getTriggerTime() != null ? jobStatusData.getTriggerTime() : null);
    }

    public static String getJobTokenKey(IJob job) {
        return KeyUtil.getJobTokenKey(job.getTask().getId(), job.getTask().getTriggerType() == TaskTriggerTypeEnum.MANUAL ? null : (Date)job.getContext().get("trigger.time"));
    }

    public static String getJobPartnerTokenKey(String partnerId) {
        return new StringBuilder(50).append(PREFIX).append(DELIMITER).append(PARTNER_ID_PREFIX).append(DELIMITER).append(partnerId).toString();
    }

    public static String getJobRecoverKey(long jobId) {
        return new StringBuilder(50).append(PREFIX).append(DELIMITER).append(RECOVER_PREFIX).append(DELIMITER).append(jobId).toString();
    }
}

