/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.email;

import com.ericsson.cms.epgmgmt.email.EmailContentProvider;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.util.MailUtil;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DefaultEmailContentProvider
implements EmailContentProvider {
    private static final String SEPARATE_SYMBOL = "\n\r";
    private static final String SEPARATE = "  ";
    public static final String DEFAULT_SUBJECT = "found during processing ";
    public static final String ABORT_SUBJECT = "aborted";

    @Override
    public String getEmailContent(List<MessageEntry> messages) {
        if (messages == null || messages.isEmpty()) {
            return "";
        }
        Object[] texts = new String[messages.size()];
        for (int i = 0; i < messages.size(); ++i) {
            texts[i] = i + 1 + ". " + this.buildEachMessageBody(messages.get(i));
        }
        return StringUtils.join((Object[])texts, (String)SEPARATE_SYMBOL);
    }

    private String buildEachMessageBody(MessageEntry message) {
        StringBuilder content = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        content.append("Time: " + df.format(message.getDate()) + SEPARATE);
        content.append("Serverity: " + message.getLevel() + SEPARATE);
        content.append("Component: " + message.getPluginLogComponent() + SEPARATE_SYMBOL);
        content.append("Description: " + message.getMessage());
        return content.toString();
    }

    @Override
    public String getEmailSubject(Partner partner, EmailAlertLevelEnum level) {
        boolean belowAbort = level.compareTo((Enum)EmailAlertLevelEnum.ABORT) < 0;
        String currentLevel = level.toString();
        StringBuilder subject = new StringBuilder();
        subject.append("[" + currentLevel + "] ");
        if (belowAbort) {
            subject.append(currentLevel.substring(0, 1).toUpperCase() + currentLevel.substring(1).toLowerCase() + " " + DEFAULT_SUBJECT);
        }
        subject.append(MailUtil.extractPartnerClassName(partner.getClass().getName()));
        subject.append(" : " + partner.getName());
        if (!belowAbort) {
            subject.append(" aborted");
        }
        return subject.toString();
    }
}

