/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.email;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.email.MessageEntryFilter;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DefaultMessageEntryFilter
implements MessageEntryFilter {
    private static final String DEFAULT_CODE_PATTERN = ".*";
    private EmailAlertLevelEnum level = EmailAlertLevelEnum.ALL;
    private Pattern codePattern = Pattern.compile(".*");
    private String pluginLogComponent = "ALL";

    @Override
    public List<MessageEntry> filter(List<MessageEntry> messages) {
        if (messages == null || messages.isEmpty()) {
            return messages;
        }
        ArrayList<MessageEntry> list = new ArrayList<MessageEntry>(messages.size());
        for (MessageEntry me : messages) {
            if (!this.isReachLevel(me) || !this.isTargetedCode(me) || !this.isTargetedComponent(me)) continue;
            list.add(me);
        }
        return list;
    }

    private boolean isTargetedComponent(MessageEntry me) {
        return "ALL".equalsIgnoreCase(this.pluginLogComponent) || StringUtils.contains((String)this.pluginLogComponent, (String)me.getPluginLogComponent());
    }

    private boolean isTargetedCode(MessageEntry me) {
        return this.codePattern.matcher(me.getCode()).matches();
    }

    private boolean isReachLevel(MessageEntry me) {
        return me.getLevel().compareTo((Enum)this.level) >= 0;
    }

    public void setLevel(EmailAlertLevelEnum level) {
        this.level = level;
    }

    public EmailAlertLevelEnum getLevel() {
        return this.level;
    }

    public void setCodePattern(String codePattern) {
        if (StringUtils.isNotBlank((String)codePattern)) {
            this.codePattern = Pattern.compile(codePattern);
        }
    }

    public void setPluginLogComponent(String pluginLogComponent) {
        this.pluginLogComponent = pluginLogComponent;
    }

    @Override
    public EmailAlertLevelEnum getTopLevel(List<MessageEntry> messages) {
        if (messages == null || messages.isEmpty()) {
            return EmailAlertLevelEnum.ALL;
        }
        EmailAlertLevelEnum topLevel = this.getLevel();
        for (MessageEntry me : messages) {
            if (me.getLevel().compareTo((Enum)topLevel) <= 0) continue;
            topLevel = me.getLevel();
        }
        return topLevel;
    }
}

