/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.email;

import com.ericsson.cms.epgmgmt.email.EmailContentProvider;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.email.MessageEntryFilter;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.service.IMailService;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.util.MailUtil;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailProcessor
implements Processor {
    public static final String KEY_EMAIL_MESSAGE_LIST = "email.message.list";
    private IMailService mailService;
    private IPartnerManager partnerManager;
    private EmailContentProvider emailContentProvider;
    private MessageEntryFilter messageEntryFilter;

    public void process(Exchange exchange) throws Exception {
        List messages = (List)exchange.getProperty(KEY_EMAIL_MESSAGE_LIST);
        if (messages == null || messages.isEmpty()) {
            return;
        }
        List<MessageEntry> targetMessage = this.messageEntryFilter.filter(messages);
        if (targetMessage.isEmpty()) {
            return;
        }
        Partner partner = this.getPartner(exchange);
        if (partner == null || !partner.isAlert()) {
            return;
        }
        EmailAlertLevelEnum emailLevel = this.messageEntryFilter.getTopLevel(targetMessage);
        this.mailService.sendEmail(MailUtil.extractEmailAddress(partner.getEmail()), this.emailContentProvider.getEmailSubject(partner, emailLevel), this.emailContentProvider.getEmailContent(targetMessage));
    }

    private Partner getPartner(Exchange exchange) {
        long partnerId = (Long)exchange.getIn().getHeader("PARTNER_ID", (Object)-1L);
        if (partnerId != -1L) {
            return this.partnerManager.getPartner(partnerId);
        }
        return null;
    }

    @Autowired
    public void setMailService(IMailService mailService) {
        this.mailService = mailService;
    }

    @Autowired
    public void setEmailContentProvider(EmailContentProvider emailContentProvider) {
        this.emailContentProvider = emailContentProvider;
    }

    @Autowired
    public void setMessageEntryFilter(MessageEntryFilter messageEntryFilter) {
        this.messageEntryFilter = messageEntryFilter;
    }

    @Autowired
    public void setPartnerManager(IPartnerManager partnerManager) {
        this.partnerManager = partnerManager;
    }
}

