/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.EpgAlarmActivityLog;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.sql.OrderByBuilder;
import com.ericsson.cms.epgmgmt.sql.WhereBuilder;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class AlarmActivityLogManager
implements IAlarmActivityLogManager {
    private static final int MAXIMUM_DESCRIPTION_LENGTH = 2000;
    private static Logger logger = Logger.getLogger(AlarmActivityLogManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public void log(PluginLogSeverity severity, PluginLogComponent component, String description) {
        this.log(severity, component, description, -1L, null);
    }

    @Transactional
    public void log(PluginLogSeverity severity, PluginLogComponent component, String description, long sourceId, String sourceType) {
        String newSourceType;
        logger.trace((Object)"log(PluginLogSeverity severity, String description, long sourceId, String sourceType )");
        String msg = description == null ? "" : description;
        long newSourceId = sourceId > 0L ? sourceId : 0L;
        String string = newSourceType = sourceType == null ? "" : sourceType;
        if (description != null && description.length() > 2000) {
            msg = description.substring(0, 2000);
        }
        EpgAlarmActivityLog aal = new EpgAlarmActivityLog();
        aal.setSeverity(severity);
        aal.setComponent(component);
        aal.setDescription(msg);
        aal.setSourceId(newSourceId);
        aal.setSourceType(newSourceType);
        this.create(aal);
        logger.trace((Object)"log(PluginLogSeverity severity, String description, long sourceId, String sourceType");
    }

    @Transactional
    public void create(EpgAlarmActivityLog activity) {
        logger.debug((Object)"create(EpgAlarmActivityLog) - start");
        this.entityManager.persist((Object)activity);
        this.entityManager.flush();
        logger.debug((Object)"create(EpgAlarmActivityLog) - end");
    }

    @Transactional
    public List<EpgAlarmActivityLog> getCompleteAlarmActivityLog() {
        logger.debug((Object)"getCompleteAlarmActivityLog() - start");
        List alarmActivityLog = null;
        Query query = this.entityManager.createNamedQuery("EpgAlarmActivityLog.findAll");
        alarmActivityLog = query.getResultList();
        logger.debug((Object)"getCompleteAlarmActivityLog() - end");
        return alarmActivityLog;
    }

    @Transactional
    public List<EpgAlarmActivityLog> getAlaramActivityLogByFilter(int start, int count, String sortProperty, boolean isAscending, String severity, String component, long sourceId, String sourceType, Date startDate, Date endDate) {
        logger.debug((Object)"getAlaramActivityLogByFilter(int, int, String, boolean, String, String, long, String, Date, Date) - start");
        List result = null;
        String orderBy = new OrderByBuilder().withOrder(sortProperty, "severity", "aal.severity", isAscending).withOrder(sortProperty, "component", "aal.component", isAscending).withOrder(sortProperty, "description", "aal.description", isAscending).withOrder(sortProperty, "sourceId", "aal.source_id", isAscending).withOrder(sortProperty, "sourceType", "aal.source_type", isAscending).withDefaultOrder("aal.createdDate", isAscending).withDefaultOrder("aal.id", isAscending).build();
        Query query = this.buildCriteriaQuery(severity, component, sourceId, sourceType, startDate, endDate, orderBy);
        query.setFirstResult(start);
        query.setMaxResults(count == 0 ? Integer.MAX_VALUE : count);
        result = query.getResultList();
        logger.debug((Object)"getAlaramActivityLogByFilter(int, int, String, boolean, String, String, long, String, Date, Date) - end");
        return result;
    }

    @Transactional
    public long getCountAlaramActivityLogByFilter(String severity, String component, long sourceId, String sourceType, Date startDate, Date endDate) {
        logger.debug((Object)"getCountAlaramActivityLogByFilter(String, String, long, String, Date, Date) - start");
        Query query = this.buildCountCriteriaQuery(severity, component, sourceId, sourceType, startDate, endDate, null);
        long result = (Long)query.getSingleResult();
        logger.debug((Object)"getCountAlaramActivityLogByFilter(String, String, long, String, Date, Date) - end");
        return result;
    }

    @Transactional
    public int removeExpiredLogs(Date startDate) {
        logger.debug((Object)"removeExpiredLogs() - start");
        Query query = this.entityManager.createNamedQuery("EpgAlarmActivityLog.removeExpiredLogs");
        int result = query.setParameter("UPDATE_DATE", (Object)startDate).executeUpdate();
        logger.debug((Object)"removeExpiredLogs() - end");
        return result;
    }

    private Query buildCriteriaQuery(String severity, String component, long sourceId, String sourceType, Date startDate, Date endDate, String orderByClause) {
        logger.debug((Object)"buildCriteriaQuery(String, String, long, String, Date, Date, String) - start");
        StringBuilder queryStr = new StringBuilder("SELECT aal FROM EpgAlarmActivityLog aal ");
        boolean hadDateCondition = startDate != null && endDate != null && startDate.compareTo(endDate) <= 0;
        WhereBuilder where = this.buildWhere(severity, component, sourceId, sourceType, hadDateCondition);
        queryStr.append(where.build());
        if (StringUtils.isNotBlank((String)orderByClause)) {
            queryStr.append(orderByClause);
        }
        Query query = this.entityManager.createQuery(queryStr.toString());
        if (hadDateCondition) {
            query.setParameter("start", startDate, TemporalType.TIMESTAMP);
            query.setParameter("end", CalendarUtil.addDayToDate((Date)endDate, (int)1), TemporalType.TIMESTAMP);
        }
        logger.debug((Object)"buildCriteriaQuery(String, String, long, long, Date, Date, String) - end");
        return query;
    }

    private Query buildCountCriteriaQuery(String severity, String component, long sourceId, String sourceType, Date startDate, Date endDate, String orderByClause) {
        logger.debug((Object)"buildCountCriteriaQuery(String, String, long, String, Date, Date, String) - start");
        StringBuilder queryStr = new StringBuilder("SELECT count(aal) FROM EpgAlarmActivityLog aal ");
        boolean hadDateCondition = startDate != null && endDate != null && startDate.compareTo(endDate) <= 0;
        WhereBuilder where = this.buildWhere(severity, component, sourceId, sourceType, hadDateCondition);
        queryStr.append(where.build());
        if (StringUtils.isNotBlank((String)orderByClause)) {
            queryStr.append(orderByClause);
        }
        Query query = this.entityManager.createQuery(queryStr.toString());
        if (hadDateCondition) {
            query.setParameter("start", startDate, TemporalType.TIMESTAMP);
            query.setParameter("end", CalendarUtil.addDayToDate((Date)endDate, (int)1), TemporalType.TIMESTAMP);
        }
        logger.debug((Object)"buildCountCriteriaQuery(String, String, long, long, Date, Date, String) - end");
        return query;
    }

    private WhereBuilder buildWhere(String severity, String component, long sourceId, String sourceType, boolean hadDateCondition) {
        WhereBuilder where = new WhereBuilder().withAnd(!StringUtils.equalsIgnoreCase((String)severity, (String)"ALL"), "aal.severity", severity).withAnd(!StringUtils.equalsIgnoreCase((String)component, (String)"ALL"), "aal.component", component).withAnd(!StringUtils.equalsIgnoreCase((String)sourceType, (String)"ALL"), "aal.sourceType", sourceType).withAnd(sourceId > 0L, "aal.sourceId", sourceId).withAnd(hadDateCondition, "(aal.createdDate >= :start and aal.createdDate < :end)");
        return where;
    }
}

