/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Compression;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EPGPluginTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginManager;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

public class EPGMetadataManager
implements IEPGMetadataManager {
    private static Log logger = LogFactory.getLog(EPGMetadataManager.class);
    private static final String NAME = "NAME";
    private static final String TYPE = "TYPE";
    private static final String JAR_NAME = "JARNAME";
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public List<EpgFormat> getAllEpgFormatDetails() {
        logger.debug((Object)"getAllEpgFormatDetails() - start");
        Query query = this.entityManager.createNamedQuery("EpgFormat.findAll");
        List returnList = query.getResultList();
        logger.debug((Object)"getAllEpgFormatDetails() - end");
        return returnList;
    }

    @Transactional
    public EpgFormat getEpgFormatDetailsbyName(String formatName) {
        logger.debug((Object)"getEpgFormatDetailsbyName(String) - start");
        EpgFormat returnEpgFormat = null;
        Query query = this.entityManager.createNamedQuery("EpgFormat.byName");
        try {
            query.setParameter(NAME, (Object)formatName);
            returnEpgFormat = (EpgFormat)query.getSingleResult();
            logger.debug((Object)"getEpgFormatDetailsbyName(String) - end");
            return returnEpgFormat;
        }
        catch (NoResultException nrEx) {
            logger.error((Object)"Error found while retrieving EPGFormat Details", (Throwable)nrEx);
            return returnEpgFormat;
        }
        catch (NonUniqueResultException nqrEx) {
            List returnList = query.getResultList();
            return (EpgFormat)returnList.get(0);
        }
    }

    @Transactional
    public EpgFormat getEpgFormatDetailsbyId(String id) {
        logger.debug((Object)"getEpgFormatDetailsbyId(long) - start");
        EpgFormat returnEpgFormat = (EpgFormat)this.entityManager.find(EpgFormat.class, (Object)id);
        logger.debug((Object)"getEpgFormatDetailsbyId(long) - end");
        return returnEpgFormat;
    }

    @Transactional
    public List<EpgFormat> getEpgFormatDetailsbyNameType(String formatName, String type) {
        List returnEpgFormat = null;
        Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginNameType");
        query.setParameter(NAME, (Object)formatName);
        query.setParameter(TYPE, (Object)type);
        returnEpgFormat = query.getResultList();
        logger.debug((Object)"getEpgFormatDetailsbyName(String) - end");
        return returnEpgFormat;
    }

    @Transactional
    public EpgFormat getEpgFormatByPluginFileName(String fileName) {
        EpgFormat returnEpgFormat = null;
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginFileName");
            query.setParameter(JAR_NAME, (Object)fileName);
            returnEpgFormat = (EpgFormat)query.getSingleResult();
            logger.debug((Object)"getEpgFormatDetailsbyName(String) - end");
            return returnEpgFormat;
        }
        catch (NoResultException nrEx) {
            return returnEpgFormat;
        }
    }

    @Transactional
    public List<Compression> getAllCompressionDetails() {
        logger.debug((Object)"getAllCompressionDetails() - start");
        Query query = this.entityManager.createNamedQuery("Compression.findAll");
        List returnList = query.getResultList();
        logger.debug((Object)"getAllCompressionDetails() - end");
        return returnList;
    }

    @Transactional
    public void createOrUpdate(EpgFormat epgFormat) {
        EpgFormat conflict = this.getEpgFormatByPluginFileName(epgFormat.getJarName());
        epgFormat = (EpgFormat)this.entityManager.merge((Object)epgFormat);
        if (conflict != null && !conflict.getId().equals(epgFormat.getId())) {
            this.entityManager.remove((Object)conflict);
        }
    }

    @Transactional
    public void createEpgFormat(EpgFormat epgFormat) {
        logger.debug((Object)"createEpgFormat(EpgFormat) - start");
        this.entityManager.persist((Object)epgFormat);
        logger.debug((Object)"createEpgFormat(EpgFormat) - end");
    }

    @Transactional
    public EpgFormat getEpgFormatDetailsbyNameTypeJar(String formatName, String type, String jarName) {
        logger.debug((Object)"getEpgFormatDetailsbyNameTypeJar(String, String, String) - start");
        EpgFormat returnEpgFormat = null;
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginNameTypeJar");
            query.setParameter(NAME, (Object)formatName);
            query.setParameter(TYPE, (Object)type);
            query.setParameter(JAR_NAME, (Object)jarName);
            returnEpgFormat = (EpgFormat)query.getSingleResult();
            logger.debug((Object)"getEpgFormatDetailsbyName(String,String,String) - end");
            return returnEpgFormat;
        }
        catch (NoResultException nrEx) {
            logger.debug((Object)"getEpgFormatDetailsbyNameTypeJar(String, String, String) - end");
            return returnEpgFormat;
        }
    }

    @Transactional
    public List<EpgFormat> getAllProvidersEpgFormats() {
        logger.debug((Object)"getAllProvidersEpgFormats() - start");
        List returnList = null;
        Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginType");
        query.setParameter(TYPE, (Object)EPGPluginTypeEnum.Provider.toString());
        returnList = query.getResultList();
        logger.debug((Object)"getAllProvidersEpgFormats() - end");
        return returnList;
    }

    @Transactional
    public List<EpgFormat> getAllPublishersEpgFormats() {
        logger.debug((Object)"getAllPublishersEpgFormats() - start");
        List returnList = null;
        Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginType");
        query.setParameter(TYPE, (Object)EPGPluginTypeEnum.Publisher.toString());
        returnList = query.getResultList();
        logger.debug((Object)"getAllPublishersEpgFormats() - end");
        return returnList;
    }

    @Transactional
    public void updateEpgFormatById(EpgFormat format) {
        this.entityManager.merge((Object)format);
    }

    @Transactional
    public EpgFormat getEpgFormat(Task task) {
        String type = task.getType() == TaskTypeEnum.INGEST ? EPGPluginTypeEnum.Provider.toString() : EPGPluginTypeEnum.Publisher.toString();
        return this.getLatestEpgFormat(type, task.getFormatName());
    }

    @Transactional
    public EpgFormat getLatestEpgFormat(String type, String name) {
        List<EpgFormat> formats = this.getEpgFormatDetailsbyNameType(name, type);
        if (formats == null) {
            return null;
        }
        String latestVersion = "0.0";
        EpgFormat latestFormat = null;
        for (EpgFormat format : formats) {
            if (!format.isActive() || EPGPluginManager.compareVersion(format.getVersion(), latestVersion) <= 0) continue;
            latestFormat = format;
            latestVersion = format.getVersion();
        }
        return latestFormat;
    }

    public PluginPropertyEntity getPluginPropertyEntity(String propertyId) {
        return (PluginPropertyEntity)this.entityManager.find(PluginPropertyEntity.class, (Object)propertyId);
    }
}

