/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Schedule;
import com.ericsson.cms.epgmgmt.entity.Station;
import com.ericsson.cms.epgmgmt.service.IEPGScheduleManager;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.springframework.transaction.annotation.Transactional;

public class EPGScheduleManager
implements IEPGScheduleManager {
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;

    @Transactional
    public List<Schedule> getSchedules(String providerId, Date startTime, Date endTime, Station station) {
        Query query = this.entityManager.createNamedQuery("Schedule.findIncludeProgByStation");
        query.setParameter("PROVIDER_ID", (Object)providerId);
        query.setParameter("STATIONID", (Object)station.getStationId().getStationId());
        query.setParameter("STARTTIME", startTime, TemporalType.TIMESTAMP);
        query.setParameter("ENDTIME", endTime, TemporalType.TIMESTAMP);
        List resultList = null;
        try {
            resultList = query.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.removeUnwantedFirstLastRecords(resultList, startTime, endTime);
        return resultList;
    }

    public void removeUnwantedFirstLastRecords(List<Schedule> resultList, Date startTime, Date endTime) {
        int listSize = resultList.size();
        if (listSize > 0) {
            if (resultList.get(0).getEndTime().compareTo(startTime) == 0) {
                resultList.remove(0);
            }
            if ((listSize = resultList.size()) > 0 && resultList.get(listSize - 1).getStartTime().compareTo(endTime) == 0) {
                resultList.remove(listSize - 1);
            }
        }
    }

    @Transactional
    public String getScheduleWindow() {
        Query query = this.entityManager.createNamedQuery("Schedule.minMaxTime");
        Object[] timeStamps = (Object[])query.getSingleResult();
        StringBuilder sb = new StringBuilder();
        sb.append(" Start time - " + ((Timestamp)timeStamps[0]).toString());
        sb.append(" End time - " + ((Timestamp)timeStamps[1]).toString());
        return sb.toString();
    }
}

