/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Headend;
import com.ericsson.cms.epgmgmt.service.IHeadendManager;
import java.math.BigInteger;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

public class HeadendManager
implements IHeadendManager {
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;

    @Transactional
    public List<Headend> getAllHeadends() {
        return this.entityManager.createNamedQuery("Headend.findAll").getResultList();
    }

    @Transactional
    public void create(Headend he) {
        this.entityManager.persist((Object)he);
    }

    @Transactional
    public void update(Headend he) {
        this.entityManager.merge((Object)he);
    }

    @Transactional
    public String getEpgSummary() {
        StringBuilder builder = new StringBuilder(100);
        builder.append(" Total Headends - " + this.getCount("HEADEND") + "\n");
        builder.append(" Total Lineups  - " + this.getCount("LINEUP") + "\n");
        builder.append(" Total Stations - " + this.getCount("STATION") + "\n");
        builder.append(" Total Schedules - " + this.getCount("SCHEDULE") + "\n");
        builder.append(" Total Programs- " + this.getCount("PROGRAM") + "\n");
        return builder.toString();
    }

    private Long getCount(String tableName) {
        Query query = this.entityManager.createNativeQuery("select count(1) from " + tableName);
        Object result = query.getSingleResult();
        if (result instanceof Long) {
            return (Long)result;
        }
        return ((BigInteger)result).longValue();
    }

    @Transactional
    public List<Headend> getHeadendsByProviderId(String providerId) {
        List headends = null;
        try {
            Query query = this.entityManager.createNamedQuery("Headend.findByProviderId");
            query.setParameter("providerId", (Object)providerId);
            headends = query.getResultList();
        }
        catch (NoResultException etEx) {
            return headends;
        }
        return headends;
    }

    public int getTotalHeadendsCount(String providerId) {
        String queryStr = "SELECT count(*) FROM Headend he WHERE he.headendId.providerId = :PROVIDERID ";
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("PROVIDERID", (Object)providerId);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }
}

