/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.JobEntity;
import com.ericsson.cms.epgmgmt.entity.JobFilter;
import com.ericsson.cms.epgmgmt.entity.PageFilter;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.service.IJobManager;
import com.ericsson.cms.epgmgmt.sql.OrderByBuilder;
import com.ericsson.cms.epgmgmt.sql.WhereBuilder;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class JobManager
implements IJobManager {
    private static final EnumSet<JobStatusEnum> COMPLETE_STATUS = EnumSet.of(JobStatusEnum.CANCELD, JobStatusEnum.COMPLETED, JobStatusEnum.FAILDED);
    private static final EnumSet<JobStatusEnum> ALL_STATUS = EnumSet.allOf(JobStatusEnum.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public boolean createJob(JobEntity job) {
        this.entityManager.persist((Object)job);
        return true;
    }

    public JobEntity getJob(long jobId) {
        return (JobEntity)this.entityManager.find(JobEntity.class, (Object)jobId);
    }

    @Transactional
    public List<JobEntity> getPartnerRecentJobs(long partnerId, TaskTypeEnum type, Date minStartDate) {
        Query query = this.entityManager.createNamedQuery("JobEntity.findRecentJobs");
        query.setParameter("TYPE", (Object)type);
        query.setParameter("PARTNER_ID", (Object)partnerId);
        query.setParameter("START_DATE", (Object)minStartDate);
        return query.getResultList();
    }

    @Transactional
    public void update(JobEntity job) {
        this.entityManager.merge((Object)job);
    }

    @Transactional(readOnly=true)
    public List<JobEntity> getJobs() {
        return this.entityManager.createNamedQuery("JobEntity.findAll").getResultList();
    }

    @Transactional
    public int removeExpiredJob(Date startDate) {
        Query query = this.entityManager.createNamedQuery("JobEntity.removeExpiredJobs");
        return query.setParameter("START_DATE", (Object)startDate).executeUpdate();
    }

    private Query buildQueryByFilter(String selectStr, long partnerId, long taskId, String jobType, Date startDate, Date endDate, String orderByClause, Class<?> result) {
        StringBuilder queryStr = new StringBuilder(selectStr);
        boolean hadDateCondition = startDate != null && endDate != null;
        WhereBuilder where = new WhereBuilder().withAnd(true, "j.partner_id =:partner_id").withAnd(taskId != -1L, "j.task_id", taskId).withAnd(StringUtils.isNotBlank((String)jobType), "j.type", jobType).withAnd(hadDateCondition, "(j.start_date >= :start and j.start_date <= :end or j.end_date is not null and j.end_date >= :start and j.end_date <= :end)");
        queryStr.append(where.build());
        if (StringUtils.isNotBlank((String)orderByClause)) {
            queryStr.append(orderByClause);
        }
        Query query = null;
        query = result != null ? this.entityManager.createNativeQuery(queryStr.toString(), result) : this.entityManager.createNativeQuery(queryStr.toString());
        query.setParameter("partner_id", (Object)partnerId);
        if (hadDateCondition) {
            query.setParameter("start", startDate, TemporalType.TIMESTAMP);
            query.setParameter("end", CalendarUtil.addDayToDate((Date)endDate, (int)1), TemporalType.TIMESTAMP);
        }
        return query;
    }

    @Transactional
    public List<JobEntity> findJobsByFilter(JobFilter filter, PageFilter pageFilter) {
        String orderBy = new OrderByBuilder().withDefaultOrder("j.start_date", pageFilter.isAscending()).withDefaultOrder("j.job_id", pageFilter.isAscending()).build();
        String selectStr = "SELECT j.* FROM EPG_JOB j";
        Query query = this.buildQueryByFilter(selectStr, filter.getPartnerId(), filter.getTaskId(), filter.getPartnerType(), this.convert2Date(filter.getStartDate()), this.convert2Date(filter.getEndDate()), orderBy, JobEntity.class);
        query.setFirstResult(pageFilter.getStart());
        query.setMaxResults(pageFilter.getCount() == 0 ? Integer.MAX_VALUE : pageFilter.getCount());
        return query.getResultList();
    }

    private Date convert2Date(long date) {
        return date == 0L ? null : new Date(date);
    }

    @Transactional
    public long countByFilter(JobFilter filter) {
        String selectStr = "SELECT count(*) FROM EPG_JOB j ";
        Query query = this.buildQueryByFilter(selectStr, filter.getPartnerId(), filter.getTaskId(), filter.getPartnerType(), this.convert2Date(filter.getStartDate()), this.convert2Date(filter.getEndDate()), null, null);
        return ((Number)query.getSingleResult()).longValue();
    }

    @Transactional
    public long findRecentStartTime(long taskId) {
        Query query = this.entityManager.createNamedQuery("JobEntity.findJobsForTask");
        query.setParameter("TASK_ID", (Object)taskId);
        query.setParameter("STATUS_LIST", COMPLETE_STATUS);
        List jobs = query.setFirstResult(0).setMaxResults(1).getResultList();
        if (CollectionUtils.isEmpty((Collection)jobs)) {
            return 0L;
        }
        return ((JobEntity)jobs.get(0)).getStartDate().getTime();
    }

    public JobStatusEnum findRecentJobStatus(long taskId) {
        Query query = this.entityManager.createNamedQuery("JobEntity.findJobsForTask");
        query.setParameter("TASK_ID", (Object)taskId);
        query.setParameter("STATUS_LIST", COMPLETE_STATUS);
        List jobs = query.setFirstResult(0).setMaxResults(1).getResultList();
        if (CollectionUtils.isEmpty((Collection)jobs)) {
            return null;
        }
        return ((JobEntity)jobs.get(0)).getStatus();
    }

    public JobEntity findRecentJob(long taskId) {
        Query query = this.entityManager.createNamedQuery("JobEntity.findJobsForTask");
        query.setParameter("TASK_ID", (Object)taskId);
        query.setParameter("STATUS_LIST", ALL_STATUS);
        List jobs = query.setFirstResult(0).setMaxResults(1).getResultList();
        if (CollectionUtils.isEmpty((Collection)jobs)) {
            return null;
        }
        return (JobEntity)jobs.get(0);
    }
}

