/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.JobFilter;
import com.ericsson.cms.epgmgmt.entity.JobTrace;
import com.ericsson.cms.epgmgmt.entity.PageFilter;
import com.ericsson.cms.epgmgmt.service.IJobTraceManager;
import com.ericsson.cms.epgmgmt.sql.OrderByBuilder;
import com.ericsson.cms.epgmgmt.sql.WhereBuilder;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class JobTraceManager
implements IJobTraceManager {
    private static Logger logger = Logger.getLogger(JobTraceManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public JobTrace createJobTrace(JobTrace jobTrace) {
        this.entityManager.persist((Object)jobTrace);
        return jobTrace;
    }

    @Transactional
    public JobTrace updateJobTrace(JobTrace jobTrace) {
        return (JobTrace)this.entityManager.merge((Object)jobTrace);
    }

    @Transactional(readOnly=true)
    public JobTrace getJobTrace(long jobId) {
        return (JobTrace)this.entityManager.find(JobTrace.class, (Object)jobId);
    }

    @Transactional
    public void deleteJobTrace(long jobId) {
        try {
            this.entityManager.remove(this.entityManager.getReference(JobTrace.class, (Object)jobId));
        }
        catch (EntityNotFoundException e) {
            logger.info((Object)("Try to delete JobTrace[" + jobId + "] but not found."));
        }
    }

    @Transactional(readOnly=true)
    public JobTrace getJobTrace(String ip, int port) {
        try {
            Query q = this.entityManager.createNamedQuery("JobTrace.findLastUnfinishedForServer");
            q.setParameter("ip", (Object)ip);
            q.setParameter("port", (Object)port);
            List result = q.getResultList();
            if (result.size() == 0) {
                logger.info((Object)("No JobTrace found for IP[" + ip + "] and port[" + port + "]"));
                return null;
            }
            if (result.size() > 1) {
                logger.warn((Object)("There're " + result.size() + " jobs in the system that is not finished for server[" + ip + "], something is wrong in the DB"));
            }
            return (JobTrace)result.get(0);
        }
        catch (NoResultException e) {
            logger.info((Object)("No JobTrace found for IP[" + ip + "] and port[" + port + "]"));
            return null;
        }
    }

    @Transactional(readOnly=true)
    public List<JobTrace> getUnfinishedJobs() {
        try {
            return this.entityManager.createNamedQuery("JobTrace.findUnfinishedJobs").getResultList();
        }
        catch (NoResultException e) {
            logger.info((Object)"No unfinished job found", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Transactional
    public void finishJobTrace(long jobId) {
        try {
            JobTrace jobTrace = (JobTrace)this.entityManager.getReference(JobTrace.class, (Object)jobId);
            jobTrace.setFinished(true);
            this.entityManager.merge((Object)jobTrace);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Transactional
    public int removeExpiredJobs(Date startDate) {
        Query query = this.entityManager.createNamedQuery("JobTrace.removeExpiredJobs");
        return query.setParameter("START_TIME", (Object)startDate).executeUpdate();
    }

    @Transactional(readOnly=true)
    public boolean isJobFinished(long jobId) {
        return (Boolean)this.entityManager.createNamedQuery("JobTrace.isJobFinished").setParameter("jobId", (Object)jobId).getSingleResult();
    }

    @Transactional
    public long countByFilter(JobFilter filter) {
        String selectStr = "SELECT count(*) FROM JOB_TRACE jt INNER JOIN EPG_JOB j ON jt.JOB_ID = j.JOB_ID";
        Query query = this.buildQueryByFilter(selectStr, filter.getPartnerId(), filter.getTaskId(), filter.getPartnerType(), this.convert2Date(filter.getStartDate()), this.convert2Date(filter.getEndDate()), null, null);
        return ((Number)query.getSingleResult()).longValue();
    }

    @Transactional
    public List<JobTrace> findByFilter(JobFilter filter, PageFilter pageFilter) {
        String orderBy = new OrderByBuilder().withDefaultOrder("j.start_date", pageFilter.isAscending()).withDefaultOrder("j.job_id", pageFilter.isAscending()).build();
        String selectStr = "SELECT jt.*, j.* FROM JOB_TRACE jt INNER JOIN EPG_JOB j ON jt.JOB_ID = j.JOB_ID";
        Query query = this.buildQueryByFilter(selectStr, filter.getPartnerId(), filter.getTaskId(), filter.getPartnerType(), this.convert2Date(filter.getStartDate()), this.convert2Date(filter.getEndDate()), orderBy, JobTrace.class);
        query.setFirstResult(pageFilter.getStart());
        query.setMaxResults(pageFilter.getCount() == 0 ? Integer.MAX_VALUE : pageFilter.getCount());
        return query.getResultList();
    }

    private Query buildQueryByFilter(String selectStr, long partnerId, long taskId, String jobType, Date startDate, Date endDate, String orderByClause, Class<?> result) {
        StringBuilder queryStr = new StringBuilder(selectStr);
        boolean hadDateCondition = startDate != null && endDate != null;
        WhereBuilder where = new WhereBuilder().withAnd(true, "j.partner_id =:partner_id").withAnd(taskId != -1L, "j.task_id", taskId).withAnd(StringUtils.isNotBlank((String)jobType), "j.type", jobType).withAnd(hadDateCondition, "(j.start_date >= :start and j.start_date <= :end)");
        queryStr.append(where.build());
        if (StringUtils.isNotBlank((String)orderByClause)) {
            queryStr.append(orderByClause);
        }
        Query query = null;
        query = result != null ? this.entityManager.createNativeQuery(queryStr.toString(), result) : this.entityManager.createNativeQuery(queryStr.toString());
        query.setParameter("partner_id", (Object)partnerId);
        if (hadDateCondition) {
            query.setParameter("start", startDate, TemporalType.TIMESTAMP);
            query.setParameter("end", CalendarUtil.addDayToDate((Date)endDate, (int)1), TemporalType.TIMESTAMP);
        }
        return query;
    }

    private Date convert2Date(long date) {
        return date == 0L ? null : new Date(date);
    }
}

