/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.service.DataValidationException;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.validation.PartnerValidator;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class PartnerManager
implements IPartnerManager {
    private static Log logger = LogFactory.getLog(PartnerManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;
    private ITaskManager taskManager;
    private DataSource dataSource;
    private String[] productionTables;
    private long deleteProviderRecordThreshold;

    @Transactional
    public long create(Partner partner) throws DataValidationException {
        logger.debug((Object)"create(Partner) - start");
        partner.setId(null);
        new PartnerValidator(this.entityManager).validatePartner(partner);
        this.entityManager.persist((Object)partner);
        logger.debug((Object)"create(Partner) - end");
        return partner.getId();
    }

    @Transactional
    public Partner getPartner(long id) {
        logger.debug((Object)"getPartner(long) - start");
        Partner partner = (Partner)this.entityManager.find(Partner.class, (Object)id);
        if (partner != null) {
            partner.getNormalizationGroups().size();
            partner.getValidationGroups().size();
        }
        logger.debug((Object)"getPartner(long) - end");
        return partner;
    }

    @Transactional
    public List<Partner> getPartners() {
        logger.debug((Object)"getPartners() - start");
        Query query = this.entityManager.createNamedQuery("Partner.findAll");
        List partners = query.getResultList();
        logger.debug((Object)"getPartners() - end");
        return partners;
    }

    @Transactional
    public Partner getPartnerByName(String name) {
        try {
            logger.debug((Object)"getPartners() - start");
            Query query = this.entityManager.createNamedQuery("Partner.byName");
            query.setParameter("NAME", (Object)name);
            Partner partner = (Partner)query.getSingleResult();
            logger.debug((Object)"getPartners() - end");
            return partner;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Transactional
    public void removePartnerById(long id) {
        logger.debug((Object)"removePartnerById(long) - start");
        Partner partner = (Partner)this.entityManager.find(Partner.class, (Object)id);
        if (partner.getPartnerType() == PartnerTypeEnum.Provider) {
            this.disableReceivers(partner);
        }
        this.entityManager.remove((Object)partner);
        logger.debug((Object)"removePartnerById(long) - end");
    }

    private void disableReceivers(Partner partner) {
        List tasks = this.taskManager.getExportTasksForProvider(partner.getId());
        for (Task task : tasks) {
            task.setEnabled(false);
        }
    }

    @Transactional
    public void update(Partner partner) throws DataValidationException {
        logger.debug((Object)"update(Partner) - start");
        new PartnerValidator(this.entityManager).validatePartner(partner);
        Partner existingPartner = (Partner)this.entityManager.merge((Object)partner);
        existingPartner.setUpdateDate(new Date());
        logger.debug((Object)"update(Partner) - end");
    }

    @Transactional
    public List<Provider> getAllProviders() {
        logger.debug((Object)"getAllProviders() - start");
        List providersList = null;
        Query query = this.entityManager.createNamedQuery("Provider.findAll");
        providersList = query.getResultList();
        logger.debug((Object)"getAllProviders() - end");
        return providersList;
    }

    @Transactional
    public List<Publisher> getAllPublishers() {
        logger.debug((Object)"getAllPublisher() - start");
        List publishers = null;
        Query query = this.entityManager.createNamedQuery("Publisher.findAll");
        publishers = query.getResultList();
        logger.debug((Object)"getAllPublisher() - end");
        return publishers;
    }

    @Transactional
    public Provider getProvider(long id) {
        logger.debug((Object)"getProvider(long) - start");
        Provider provider = null;
        provider = (Provider)this.entityManager.find(Provider.class, (Object)id);
        if (provider != null) {
            provider.getValidationGroups().size();
            provider.getNormalizationGroups().size();
        }
        logger.debug((Object)"getProvider(long) - end");
        return provider;
    }

    @Transactional
    public Publisher getPublisher(long id) {
        logger.debug((Object)"getPublisher(long) - start");
        Publisher publisher = null;
        publisher = (Publisher)this.entityManager.find(Publisher.class, (Object)id);
        if (publisher != null) {
            publisher.getNormalizationGroups().size();
        }
        logger.debug((Object)"getPublisher(long) - end");
        return publisher;
    }

    @Transactional
    public Publisher getPublisherByName(String publisherName) {
        logger.debug((Object)"getPublisherByName(String) - start");
        Publisher publisher = null;
        try {
            Query query = this.entityManager.createNamedQuery("Publisher.byName");
            query.setParameter("NAME", (Object)publisherName);
            publisher = (Publisher)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return publisher;
        }
        logger.debug((Object)"getPublisherByName(String) - end");
        return publisher;
    }

    @Transactional
    public Provider getProviderByName(String name) {
        logger.debug((Object)"getProviderByName(String) - start");
        Provider provider = null;
        try {
            Query query = this.entityManager.createNamedQuery("Provider.byName");
            query.setParameter("NAME", (Object)name);
            provider = (Provider)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return provider;
        }
        logger.debug((Object)"getProviderByName(String) - end");
        return provider;
    }

    @Transactional
    public List<Partner> getProviders() {
        logger.debug((Object)"getAllProviders() - start");
        List providersList = null;
        Query query = this.entityManager.createNamedQuery("Provider.findAll");
        providersList = query.getResultList();
        logger.debug((Object)"getAllProviders() - end");
        return providersList;
    }

    @Transactional
    public List<Partner> getPublishers() {
        logger.debug((Object)"getAllPublisher() - start");
        List publishers = null;
        Query query = this.entityManager.createNamedQuery("Publisher.findAll");
        publishers = query.getResultList();
        logger.debug((Object)"getAllPublisher() - end");
        return publishers;
    }

    @Transactional
    public long canDeleteProvider(long id) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        long totalRecrodCont = 0L;
        for (String table : this.productionTables) {
            String sqlCmd = String.format("select count(*) from %s where PROVIDER_ID =%d", table, id);
            if ((totalRecrodCont += jdbcTemplate.queryForLong(sqlCmd)) <= this.deleteProviderRecordThreshold) continue;
            return this.deleteProviderRecordThreshold;
        }
        return -1L;
    }

    @Transactional(readOnly=true)
    public long countProviders() {
        return (Long)this.entityManager.createNamedQuery("Provider.countAll").getSingleResult();
    }

    @Transactional(readOnly=true)
    public long countPublishers() {
        return (Long)this.entityManager.createNamedQuery("Publisher.countAll").getSingleResult();
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setProductionTables(String[] productionTables) {
        this.productionTables = productionTables;
    }

    public void setDeleteProviderRecordThreshold(long deleteProviderRecordThreshold) {
        this.deleteProviderRecordThreshold = deleteProviderRecordThreshold;
    }
}

