/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.service.IPluginPropertyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

public class PluginPropertyManager
implements IPluginPropertyManager {
    private static Log logger = LogFactory.getLog(PluginPropertyManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public List<PluginPropertyEntity> getPluginProperties(String formatId) {
        logger.debug((Object)"getPluginProperties(String) - start");
        String[] parts = formatId.split("_");
        String searchKey = String.format("%s_%s", parts[0], parts[1]);
        Query query = this.entityManager.createNamedQuery("PluginProperty.byepgFormat");
        query.setParameter("FORMAT", (Object)searchKey);
        List propList = query.getResultList();
        logger.debug((Object)"getPluginProperties(String) - end");
        return propList;
    }

    @Transactional
    public List<PluginPropertyEntity> getAllPluginProperties() {
        logger.debug((Object)"getPluginProperties() - start");
        Query query = this.entityManager.createNamedQuery("PluginProperty.getAll");
        List returnList = query.getResultList();
        logger.debug((Object)"getPluginProperties() - end");
        return returnList;
    }

    @Transactional
    public List<PluginPropertyEntity> getAllPluginProperties(String type, String formatname) {
        logger.debug((Object)"getPluginProperties() - start");
        ArrayList<PluginPropertyEntity> returnList = new ArrayList<PluginPropertyEntity>();
        List<PluginPropertyEntity> allProps = this.getAllPluginProperties();
        for (PluginPropertyEntity ppe : allProps) {
            String[] parts = ppe.getId().split("_");
            if (!type.equals(parts[0]) || !formatname.equals(parts[1])) continue;
            returnList.add(ppe);
        }
        logger.debug((Object)"getPluginProperties() - end");
        return returnList;
    }

    @Transactional
    public PluginPropertyEntity getPluginProperty(String type, String formatName, String propertyName) {
        String id = String.format("%s_%s_%s", type, formatName, propertyName);
        return this.getPluginProperty(id);
    }

    @Transactional
    public PluginPropertyEntity getPluginProperty(String id) {
        try {
            Query query = this.entityManager.createNamedQuery("PluginProperty.byId");
            query.setParameter("ID", (Object)id);
            return (PluginPropertyEntity)query.getSingleResult();
        }
        catch (NoResultException nrEx) {
            return null;
        }
    }

    @Transactional
    public void addPluginPropertyIfNotExists(Set<PluginPropertyEntity> pluginProps) {
        for (PluginPropertyEntity ppe : pluginProps) {
            this.entityManager.merge((Object)ppe);
        }
    }

    @Transactional
    public void createPluginPropertyEntity(PluginPropertyEntity pluginPropertyEntity) {
        this.entityManager.persist((Object)pluginPropertyEntity);
    }

    public void mergePluginPropertyEntity(PluginPropertyEntity pluginPropertyEntity) {
        this.entityManager.merge((Object)pluginPropertyEntity);
    }
}

