/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Headend;
import com.ericsson.cms.epgmgmt.entity.Station;
import com.ericsson.cms.epgmgmt.entity.enumeration.PGSortPropertyEnum;
import com.ericsson.cms.epgmgmt.service.IStationManager;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class StationManager
implements IStationManager {
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;

    @Transactional
    public List<Station> getStations(int start, int count, Headend headend, PGSortPropertyEnum sortProperty, boolean isAscending) {
        String orderBy = this.createSortSql(sortProperty, isAscending);
        String queryStr = "SELECT st FROM Station st LEFT JOIN st.lineups lu LEFT JOIN lu.headend he WHERE he.headendId.headendId = :HEADENDID " + orderBy;
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("HEADENDID", (Object)headend.getHeadendId().getHeadendId());
        query.setFirstResult(start);
        if (count > 0) {
            query.setMaxResults(count);
        }
        List result = query.getResultList();
        this.removeDuplicatedRecord(result);
        return result;
    }

    @Transactional
    public List<Station> getStationsWithSpecifiedStationIds(String providerId, int start, int count, PGSortPropertyEnum sortProperty, boolean isAscending, String specifiedStationIdsSql) {
        StringBuilder queryStr = new StringBuilder("SELECT st FROM Station st where st.stationId.providerId = :PROVIDER_ID ");
        if (StringUtils.isNotBlank((String)specifiedStationIdsSql)) {
            queryStr.append(" and st.stationId.stationId " + specifiedStationIdsSql);
        }
        queryStr.append(this.createSortSql(sortProperty, isAscending));
        Query query = this.entityManager.createQuery(queryStr.toString());
        query.setParameter("PROVIDER_ID", (Object)providerId);
        query.setFirstResult(start);
        if (count > 0) {
            query.setMaxResults(count);
        }
        return query.getResultList();
    }

    private String createSortSql(PGSortPropertyEnum sortProperty, boolean isAscending) {
        String orderBy = " ORDER BY ";
        if (sortProperty != null) {
            switch (sortProperty) {
                case callSign: {
                    orderBy = orderBy + "st.callSign";
                    break;
                }
                case stationId: {
                    orderBy = orderBy + "st.stationId.stationId";
                    break;
                }
                case affiliation: {
                    orderBy = orderBy + "st.affiliation";
                    break;
                }
                default: {
                    orderBy = orderBy + "st.stationId.stationId";
                    break;
                }
            }
        } else {
            orderBy = orderBy + "st.stationId.stationId";
        }
        orderBy = isAscending ? orderBy + " asc" : orderBy + " desc";
        return orderBy;
    }

    @Transactional
    public List<Station> getStationsByHeadendIds(String providerId, String headendIds) {
        if (StringUtils.isEmpty((String)headendIds)) {
            return null;
        }
        String queryStr = "SELECT st FROM  Station st  JOIN st.lineups lu JOIN lu.headend he WHERE he.headendId.headendId " + headendIds + " and st.stationId.providerId = lu.id.providerId and st.stationId.providerId = he.headendId.providerId and st.stationId.providerId in ( :PROVIDERID )";
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("PROVIDERID", (Object)providerId);
        List result = query.getResultList();
        this.removeDuplicatedRecord(result);
        return result;
    }

    @Transactional
    public List<Station> getStations(int start, int count, PGSortPropertyEnum sortProperty, boolean isAscending) {
        String orderBy = this.createSortSql(sortProperty, isAscending);
        String queryStr = "SELECT st FROM Station st " + orderBy;
        Query query = this.entityManager.createQuery(queryStr);
        query.setFirstResult(start);
        if (count > 0) {
            query.setMaxResults(count);
        }
        List result = query.getResultList();
        LinkedHashSet stationIDs = new LinkedHashSet();
        stationIDs.addAll(result);
        result.clear();
        result.addAll(stationIDs);
        return result;
    }

    @Transactional
    public void create(Station st) {
        this.entityManager.persist((Object)st);
    }

    @Transactional
    public void update(Station st) {
        this.entityManager.merge((Object)st);
    }

    @Transactional
    public int count(String providerId, String specifiedStationIdsSql) {
        StringBuilder queryStr = new StringBuilder("SELECT count(DISTINCT st.stationId.stationId) FROM Station st where st.stationId.providerId = :PROVIDER_ID ");
        if (StringUtils.isNotBlank((String)specifiedStationIdsSql)) {
            queryStr.append(" and st.stationId.stationId " + specifiedStationIdsSql);
        }
        Query query = this.entityManager.createQuery(queryStr.toString());
        query.setParameter("PROVIDER_ID", (Object)providerId);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    @Transactional
    public List<Station> getStationsByProviderId(String providerId) {
        if (StringUtils.isEmpty((String)providerId)) {
            return null;
        }
        String queryStr = "SELECT st FROM Station st WHERE st.stationId.providerId in ( :PROVIDERID ) ";
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("PROVIDERID", (Object)providerId);
        List result = query.getResultList();
        this.removeDuplicatedRecord(result);
        return result;
    }

    private void removeDuplicatedRecord(List<Station> result) {
        HashSet<Station> stationIDs = new HashSet<Station>();
        stationIDs.addAll(result);
        result.clear();
        result.addAll(stationIDs);
    }

    public int getTotalStationsCount(String providerId) {
        String queryStr = "SELECT count(*) FROM Station st WHERE st.stationId.providerId = :PROVIDERID ";
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("PROVIDERID", (Object)providerId);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }
}

