/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Endpoint;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyValue;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.TaskSetting;
import com.ericsson.cms.epgmgmt.entity.enumeration.EPGPluginTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.utility.json.JsonUtil;
import com.ericsson.epgmgr.plugin.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class TaskManager
implements ITaskManager {
    private static Logger logger = Logger.getLogger(TaskManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public Task createTask(Task task, long endpointDetailId, String formatName) {
        task.setFormatName(formatName);
        task.setCreatedDate(new Date());
        task.getEndpoint().setId(null);
        this.setTaskSettingIdToNull(task.getTaskSettings());
        task.setId(null);
        this.setPluginPropertyValueIdToNull(task.getPluginPropertyValues());
        this.entityManager.persist((Object)task.getEndpoint());
        this.entityManager.persist((Object)task);
        return task;
    }

    private void setPluginPropertyValueIdToNull(List<PluginPropertyValue> ppvs) {
        if (CollectionUtils.isEmpty(ppvs)) {
            return;
        }
        for (PluginPropertyValue ppv : ppvs) {
            ppv.setId(null);
        }
    }

    private void setTaskSettingIdToNull(Set<TaskSetting> tss) {
        if (CollectionUtils.isEmpty(tss)) {
            return;
        }
        for (TaskSetting ts : tss) {
            ts.setId(null);
        }
    }

    @Transactional
    public Task createTask(Task task) {
        this.entityManager.persist((Object)task);
        return task;
    }

    @Transactional
    public Task updateTaskSelfInfo(Task task) {
        this.entityManager.merge((Object)task);
        return task;
    }

    @Transactional
    public Task updateTask(Task task) {
        Task taskInDb = (Task)this.entityManager.find(Task.class, (Object)task.getId());
        List l = taskInDb.getPluginPropertyValues();
        if (l != null) {
            l.clear();
            if (task.getPluginPropertyValues() != null) {
                l.addAll(task.getPluginPropertyValues());
            }
            task.setPluginPropertyValues(l);
        }
        HashSet<Object> settings = new HashSet<Object>();
        for (TaskSetting entry : task.getTaskSettings()) {
            settings.add(this.entityManager.merge((Object)entry));
        }
        if (task.getEndpoint() != null) {
            this.entityManager.merge((Object)task.getEndpoint());
        }
        Iterator iter = taskInDb.getTaskSettings().iterator();
        while (iter.hasNext()) {
            TaskSetting setting = (TaskSetting)iter.next();
            if (settings.contains(setting)) continue;
            this.entityManager.remove((Object)setting);
            iter.remove();
        }
        task.getTaskSettings().clear();
        task.getTaskSettings().addAll(settings);
        task.setUpdateDate(new Date());
        task.setCreatedDate(taskInDb.getCreatedDate());
        return (Task)this.entityManager.merge((Object)task);
    }

    @Transactional(readOnly=true)
    public Task getTask(long id) {
        return (Task)this.entityManager.find(Task.class, (Object)id);
    }

    @Transactional(readOnly=true)
    public List<Task> getTasks() {
        return this.entityManager.createNamedQuery("Task.findAll").getResultList();
    }

    @Transactional(readOnly=true)
    public List<Task> getIngestTasks() {
        return this.entityManager.createNamedQuery("Task.findAllIngest").getResultList();
    }

    @Transactional(readOnly=true)
    public List<Task> getExportTasks() {
        return this.entityManager.createNamedQuery("Task.findAllExport").getResultList();
    }

    @Transactional(readOnly=true)
    public List<Task> getTasksForPartner(long partnerId) {
        Query q = this.entityManager.createNamedQuery("Task.findAllForPartner");
        q.setParameter("partnerId", (Object)partnerId);
        return q.getResultList();
    }

    @Transactional
    public void activateTask(long id, Boolean isActivate) {
        Task t = (Task)this.entityManager.getReference(Task.class, (Object)id);
        t.setEnabled(isActivate.booleanValue());
        this.entityManager.merge((Object)t);
    }

    @Transactional
    public void deleteTask(long id) {
        try {
            Task task = (Task)this.entityManager.getReference(Task.class, (Object)id);
            if (task.getType() == TaskTypeEnum.INGEST) {
                this.removeSubscribers(id);
                this.removeTaskIdFromFollowIngestionList(id);
            }
            if (task.getEndpoint() != null) {
                this.entityManager.remove((Object)task.getEndpoint());
            }
            this.entityManager.remove((Object)task);
        }
        catch (EntityNotFoundException e) {
            logger.info((Object)("Try to delete a non-existing Task with ID[" + id + "]"));
        }
    }

    private void removeTaskIdFromFollowIngestionList(long id) {
        for (Task task : this.getTasks()) {
            List followingIngestionIdList;
            TaskSetting ts;
            if (task.getType() == TaskTypeEnum.EXPORT || (ts = this.getFollowingIngestionTaskSetting(task)) == null || !(followingIngestionIdList = (List)JsonUtil.parseJsonToListMap((String)ts.getSetting()).get("FollowingIngestion")).contains(String.valueOf(id))) continue;
            followingIngestionIdList.remove(String.valueOf(id));
            HashMap<String, List> settingMap = new HashMap<String, List>();
            settingMap.put("FollowingIngestion", followingIngestionIdList);
            ts.setSetting(JsonUtil.parseMapToJson(settingMap));
        }
    }

    private TaskSetting getFollowingIngestionTaskSetting(Task task) {
        for (TaskSetting ts : task.getTaskSettings()) {
            if (!ts.getKey().equals("FollowingIngestion")) continue;
            return ts;
        }
        return null;
    }

    @Transactional
    public Task getSubscribedTask(long exportTaskId) {
        Query q = this.entityManager.createQuery("select  s from TaskSetting s join s.task t where t.id=:TASK_ID and t.triggerType = :TRIG_TYPE and s.key=:KEY");
        q.setParameter("KEY", (Object)"SubscribeTo");
        q.setParameter("TASK_ID", (Object)exportTaskId);
        q.setParameter("TRIG_TYPE", (Object)TaskTriggerTypeEnum.MANUAL);
        try {
            TaskSetting taskSetting = (TaskSetting)q.getSingleResult();
            Map setting = JsonUtil.parseJsonToMap((String)taskSetting.getSetting());
            if (setting == null) {
                return null;
            }
            String taskId = (String)setting.get("SubscribeTo");
            if (StringUtils.isNotBlank((String)taskId)) {
                return this.getTask(Long.parseLong(taskId));
            }
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (NumberFormatException ex) {
            logger.error((Object)("The tasksetting SubscribeTo is not a number: taskId" + exportTaskId), (Throwable)ex);
        }
        return null;
    }

    @Transactional
    public Partner getPartnerByTaskId(long taskId) {
        return this.getTask(taskId).getPartner();
    }

    @Transactional
    public void setSubscriber(long[] exportTaskIds, Task ingestTask) {
        List<Task> oldSubscribers = this.getSubscribers(ingestTask);
        for (long exportTaskId : exportTaskIds) {
            Task task = this.getTask(exportTaskId);
            if (task == null) continue;
            oldSubscribers.remove(task);
            TaskSetting ts = this.getSubscribeSetting(task);
            if (ts != null) {
                ts.setSetting(this.getSubscribeSetting(ingestTask.getId()));
                continue;
            }
            ts = new TaskSetting("SubscribeTo", this.getSubscribeSetting(ingestTask.getId()), task);
            this.entityManager.persist((Object)ts);
            task.getTaskSettings().add(ts);
        }
        for (Task task : oldSubscribers) {
            this.entityManager.remove((Object)this.getSubscribeSetting(task));
        }
    }

    private TaskSetting getSubscribeSetting(Task task) {
        for (TaskSetting ts : task.getTaskSettings()) {
            if (!ts.getKey().equals("SubscribeTo")) continue;
            return ts;
        }
        return null;
    }

    private String getSubscribeSetting(long taskId) {
        return "{\"SubscribeTo\":\"" + taskId + "\"}";
    }

    private void removeSubscribers(long ingestTaskId) {
        Query query = this.entityManager.createQuery("select s from TaskSetting s where s.key=:KEY and s.setting = :SETTING");
        query.setParameter("KEY", (Object)"SubscribeTo");
        query.setParameter("SETTING", (Object)("{\"SubscribeTo\":\"" + ingestTaskId + "\"}"));
        List taskSettings = query.getResultList();
        for (TaskSetting ts : taskSettings) {
            this.entityManager.remove((Object)ts);
        }
    }

    @Transactional
    public List<Task> getTaskByFormat(EpgFormat epgFormat) {
        if (!epgFormat.isActive()) {
            new ArrayList();
        }
        List<Task> tasks = this.getTasks();
        ArrayList<Task> tasksWithFormat = new ArrayList<Task>();
        TaskTypeEnum type = epgFormat.getType().equals(EPGPluginTypeEnum.Provider.toString()) ? TaskTypeEnum.INGEST : TaskTypeEnum.EXPORT;
        for (Task task : tasks) {
            if (!task.getType().equals((Object)type) || !task.getFormatName().equals(epgFormat.getFormatName())) continue;
            tasksWithFormat.add(task);
        }
        return tasksWithFormat;
    }

    @Transactional
    public List<Partner> getPartnerByFormat(EpgFormat format) {
        HashSet<Partner> partners = new HashSet<Partner>();
        List<Task> tasks = this.getTaskByFormat(format);
        for (Task t : tasks) {
            partners.add(t.getPartner());
        }
        return Arrays.asList(partners.toArray(new Partner[partners.size()]));
    }

    @Transactional
    public List<Endpoint> getConflictEndpoint(Task t) {
        try {
            Query query = this.entityManager.createNamedQuery("Endpoint.findByDetail");
            Endpoint endpoint = t.getEndpoint();
            query.setParameter("endpointType", (Object)endpoint.getEndpointType());
            query.setParameter("folder", (Object)endpoint.getFolder());
            query.setParameter("fileName", (Object)endpoint.getFileName());
            query.setParameter("serverIp", (Object)endpoint.getServerIp());
            query.setParameter("port", (Object)endpoint.getPort());
            query.setParameter("endpointId", (Object)(endpoint.getId() == null ? -1L : endpoint.getId()));
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<Endpoint>();
        }
    }

    @Transactional
    public void createTaskEndPoint(Endpoint endpoint) {
        this.entityManager.persist((Object)endpoint);
    }

    @Transactional
    public void mergeTaskEndPoint(Endpoint endpoint) {
        this.entityManager.merge((Object)endpoint);
    }

    @Transactional(readOnly=true)
    public TaskSetting getTaskSetting(long id) {
        return (TaskSetting)this.entityManager.find(TaskSetting.class, (Object)id);
    }

    @Transactional(readOnly=true)
    public TaskSetting getTaskSettingByTaskIdKey(long taskId, String key) {
        try {
            Query query = this.entityManager.createNamedQuery("TaskSetting.findSubscribeTo");
            query.setParameter("TASK_ID", (Object)taskId);
            query.setParameter("KEY", (Object)key);
            return (TaskSetting)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Transactional
    public void deleteTaskSetting(long id) {
        try {
            this.entityManager.remove(this.entityManager.getReference(TaskSetting.class, (Object)id));
        }
        catch (EntityNotFoundException e) {
            logger.info((Object)("Try to delete a non-existing TaskSetting with ID[" + id + "]"));
        }
    }

    @Transactional
    public TaskSetting createTaskSetting(TaskSetting taskSetting) {
        taskSetting.setId(null);
        this.entityManager.persist((Object)taskSetting);
        return taskSetting;
    }

    @Transactional
    public TaskSetting mergeTaskSetting(TaskSetting taskSetting) {
        this.entityManager.merge((Object)taskSetting);
        return taskSetting;
    }

    public List<PluginPropertyValue> getTaskPluginPropertyValues(long taskId) {
        Query query = this.entityManager.createQuery("select p from PluginPropertyValue p join p.task t where t.id = :taskId");
        query.setParameter("taskId", (Object)taskId);
        return query.getResultList();
    }

    @Transactional
    public PluginPropertyValue createTaskPluginPropertyValue(PluginPropertyValue pluginPropertyValue) {
        this.entityManager.persist((Object)pluginPropertyValue);
        return pluginPropertyValue;
    }

    public void removeTaskPluginPropertyValues(long taskId) {
        Task t = this.getTask(taskId);
        for (PluginPropertyValue ppv : t.getPluginPropertyValues()) {
            this.entityManager.remove((Object)ppv);
        }
        t.getPluginPropertyValues().clear();
    }

    public List<Task> getSubscribers(Task ingestTask) {
        Query query = this.entityManager.createQuery("select t from Task t join t.taskSettings s where s.key=:KEY and s.setting = :SETTING");
        query.setParameter("KEY", (Object)"SubscribeTo");
        query.setParameter("SETTING", (Object)("{\"SubscribeTo\":\"" + ingestTask.getId() + "\"}"));
        return query.getResultList();
    }

    @Transactional
    public List<Task> getExportTasksForProvider(long providerId) {
        Query query = this.entityManager.createQuery("select t from Task t join t.taskSettings s where s.key=:KEY and s.setting like :SETTING");
        query.setParameter("KEY", (Object)"PublishFilters");
        query.setParameter("SETTING", (Object)("%\"Provider-Include\":[\"" + providerId + "\"]%"));
        return query.getResultList();
    }

    public List<Task> getFollowingIngestionList(Task ingestTask) {
        ArrayList<Task> followingIngestionTaskList = new ArrayList<Task>();
        Query query = this.entityManager.createNamedQuery("TaskSetting.findSubscribeTo");
        query.setParameter("KEY", (Object)"FollowingIngestion");
        query.setParameter("TASK_ID", (Object)ingestTask.getId());
        try {
            TaskSetting taskSetting = (TaskSetting)query.getSingleResult();
            Map setting = JsonUtil.parseJsonToListMap((String)taskSetting.getSetting());
            List taskIdList = (List)setting.get("FollowingIngestion");
            if (taskIdList != null) {
                for (String id : taskIdList) {
                    followingIngestionTaskList.add(this.getTask(Long.parseLong(id)));
                }
            }
        }
        catch (NoResultException ex) {
            return followingIngestionTaskList;
        }
        return followingIngestionTaskList;
    }

    public Task getTaskByNameAndPartnerId(String name, long partnerId) {
        try {
            Query q = this.entityManager.createNamedQuery("Task.findByNameAndPartnerId");
            q.setParameter("name", (Object)name);
            q.setParameter("partnerId", (Object)partnerId);
            return (Task)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getExportTaskSpecifiedProviderId(Task t) {
        String providerId = null;
        Query query = this.entityManager.createNamedQuery("TaskSetting.findSubscribeTo");
        query.setParameter("KEY", (Object)"PublishFilters");
        query.setParameter("TASK_ID", (Object)t.getId());
        try {
            TaskSetting taskSetting = (TaskSetting)query.getSingleResult();
            Map setting = JsonUtil.parseJsonToListMap((String)taskSetting.getSetting());
            List providerIdList = (List)setting.get("Provider-Include");
            if (providerIdList != null && providerIdList.size() > 0) {
                providerId = (String)providerIdList.get(0);
            }
        }
        catch (NoResultException ex) {
            return providerId;
        }
        return providerId;
    }

    public boolean getBooleanSetting(Task t, String configKey, String settingName) {
        Boolean value = null;
        Query query = this.entityManager.createNamedQuery("TaskSetting.findSubscribeTo");
        query.setParameter("KEY", (Object)configKey);
        query.setParameter("TASK_ID", (Object)t.getId());
        try {
            TaskSetting taskSetting = (TaskSetting)query.getSingleResult();
            Map setting = JsonUtil.parseJsonToMap((String)taskSetting.getSetting());
            value = (Boolean)setting.get(settingName);
        }
        catch (Exception ex) {
            logger.error((Object)("Error occurred while retriving task level \"" + settingName + "\" setting."));
        }
        return value == null ? false : value;
    }

    @Transactional
    public Task getTaskByEndpoint(long endpointId) {
        try {
            Query query = this.entityManager.createNamedQuery("Task.byEndpoint");
            query.setParameter("ID", (Object)endpointId);
            return (Task)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Transactional(readOnly=true)
    public boolean isTaskExist(long id) {
        return (Long)this.entityManager.createNamedQuery("Task.isTaskExist").setParameter("id", (Object)id).getSingleResult() != 0L;
    }
}

