/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.listener;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.cluster.message.TaskTopicMessage;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.OperationTypeEnum;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TaskListener {
    @PostUpdate
    public void onPostUpdate(final Task task) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                TaskListener.this.getHazelcastManager().getTaskTopic().publish((Object)new TaskTopicMessage(OperationTypeEnum.UPDATE, task.getId()));
            }
        });
    }

    @PostPersist
    public void onPostPersist(final Task task) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                TaskListener.this.getHazelcastManager().getTaskTopic().publish((Object)new TaskTopicMessage(OperationTypeEnum.CREATE, task.getId()));
            }
        });
    }

    @PostRemove
    public void onPostRemove(Task task) {
        task.setEnabled(false);
        this.getHazelcastManager().getTaskTopic().publish((Object)new TaskTopicMessage(OperationTypeEnum.DELETE, task.getId()));
    }

    private HazelcastManager getHazelcastManager() {
        return (HazelcastManager)ApplicationContextUtil.getBean((String)"hazelcastManager", HazelcastManager.class);
    }
}

