/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.rule.EntityMapping;
import com.ericsson.cms.epgmgmt.service.IEntityMappingManager;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

public class EntityMappingManager
implements IEntityMappingManager {
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public List<EntityMapping> getEntityMappings() {
        List entityMappingsList = null;
        Query query = this.entityManager.createNamedQuery("EntityMapping.findAll");
        entityMappingsList = query.getResultList();
        return entityMappingsList;
    }

    @Transactional
    public List<EntityMapping> getEntityMappingsByTable(String tableName) {
        List entityMappingsList = null;
        Query query = this.entityManager.createNamedQuery("EntityMapping.byTable");
        query.setParameter("TABLENAME", (Object)tableName);
        entityMappingsList = query.getResultList();
        return entityMappingsList;
    }

    @Transactional
    public EntityMapping getEntityMappingByName(String name) {
        EntityMapping entityMapping = null;
        try {
            Query query = this.entityManager.createNamedQuery("EntityMapping.byName");
            query.setParameter("NAME", (Object)name);
            entityMapping = (EntityMapping)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return entityMapping;
        }
        return entityMapping;
    }

    @Transactional
    public EntityMapping getEntityMapping(long id) {
        EntityMapping entityMapping = null;
        entityMapping = (EntityMapping)this.entityManager.find(EntityMapping.class, (Object)id);
        return entityMapping;
    }
}

