/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationRule;
import com.ericsson.cms.epgmgmt.entity.rule.predicate.ChangeCausingPredicate;
import com.ericsson.cms.epgmgmt.service.DataValidationException;
import com.ericsson.cms.epgmgmt.service.INormalizationGroupManager;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class NormalizationGroupManager
implements INormalizationGroupManager {
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public void create(NormalizationGroup normalizationGroup) throws DataValidationException {
        if (this.isDuplicateExists(normalizationGroup)) {
            throw new DataValidationException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate"));
        }
        this.entityManager.persist((Object)normalizationGroup);
    }

    @Transactional
    public void update(NormalizationGroup normalizationGroup) throws DataValidationException {
        if (!this.isDuplicateExists(normalizationGroup)) {
            NormalizationGroup objInDb = this.getGroup(normalizationGroup.getId());
            Map<Long, NormalizationRule> m = this.convertRuleMap(objInDb.getRules());
            for (NormalizationRule rule : normalizationGroup.getRules()) {
                if (((ChangeCausingPredicate)rule.getPredicate()).getId() > 0L) continue;
                if (m.containsKey(rule.getId())) {
                    this.entityManager.remove((Object)m.get(rule.getId()).getPredicate());
                }
                this.entityManager.persist((Object)rule.getPredicate());
            }
        } else {
            throw new DataValidationException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate"));
        }
        this.entityManager.merge((Object)normalizationGroup);
    }

    private Map<Long, NormalizationRule> convertRuleMap(List<NormalizationRule> rules) {
        HashMap<Long, NormalizationRule> m = new HashMap<Long, NormalizationRule>();
        for (NormalizationRule r : rules) {
            m.put(r.getId(), r);
        }
        return m;
    }

    @Transactional
    public NormalizationGroup getGroup(long groupId) {
        return (NormalizationGroup)this.entityManager.find(NormalizationGroup.class, (Object)groupId);
    }

    @Transactional
    public void removeNormalizationGroupById(long groupId) {
        this.entityManager.remove((Object)this.getGroup(groupId));
    }

    @Transactional
    public void disasociateRulesFromGroup(long gorupId, List<Long> rules) {
        String ruleIds = StringUtils.join(rules, (String)",");
        if (ruleIds.length() == 0) {
            return;
        }
        String sql = "DELETE NORM_GROUP_RULE_MAPPING WHERE NORM_RULE_GROUP_ID = " + gorupId + " and RULE_ID IN(" + ruleIds + ")";
        Query query = this.entityManager.createNativeQuery(sql);
        query.executeUpdate();
        this.entityManager.flush();
    }

    @Transactional
    public void disasociateProvidersFromGroup(long gorupId, List<Long> providers) {
        String providerIds = StringUtils.join(providers, (String)",");
        if (providerIds.length() == 0) {
            return;
        }
        String sql = "DELETE PARTNER_NORM_GROUP_MAPPING WHERE NORM_GROUP_ID = " + gorupId + " and PARTNER_ID IN(" + providerIds + ")";
        Query query = this.entityManager.createNativeQuery(sql);
        query.executeUpdate();
        this.entityManager.flush();
    }

    @Transactional
    public void disasociatePublishersFromGroup(long gorupId, List<Long> publishers) {
        String publisherIds = StringUtils.join(publishers, (String)",");
        if (publisherIds.length() == 0) {
            return;
        }
        String sql = "DELETE PUBLISHER_NORM_GROUP_MAPPING WHERE NORM_GROUP_ID = " + gorupId + " and PUBLISHER_ID IN(" + publisherIds + ")";
        Query query = this.entityManager.createNativeQuery(sql);
        query.executeUpdate();
        this.entityManager.flush();
    }

    @Transactional
    public NormalizationGroup getGroupByName(String name) {
        NormalizationGroup nGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.byName");
            query.setParameter("NAME", (Object)name);
            nGroup = (NormalizationGroup)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return nGroup;
        }
        return nGroup;
    }

    @Transactional
    public List<NormalizationRule> getAllRuleAssociationsById(long groupId) {
        List nGroupRules = null;
        NormalizationGroup nGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allRuleAssociationsById");
            query.setParameter("ID", (Object)groupId);
            nGroup = (NormalizationGroup)query.getSingleResult();
            if (nGroup != null) {
                nGroupRules = nGroup.getRules();
            }
        }
        catch (NoResultException etEx) {
            return nGroupRules;
        }
        return nGroupRules;
    }

    @Transactional
    public List<Provider> getAllProviderAssociationsById(long groupId) {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allProviderAssociationsById");
            query.setParameter("ID", (Object)groupId);
            return query.getResultList();
        }
        catch (NoResultException etEx) {
            return Collections.emptyList();
        }
    }

    @Transactional
    public List<Publisher> getAllPublisherAssociationsById(long groupId) {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allPublisherAssociationsById");
            query.setParameter("ID", (Object)groupId);
            return query.getResultList();
        }
        catch (NoResultException etEx) {
            return Collections.emptyList();
        }
    }

    @Transactional
    public Set<NormalizationGroup> getAllGlobalForProviders() {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allGlobalForProviders");
            return new HashSet<NormalizationGroup>(query.getResultList());
        }
        catch (NoResultException etEx) {
            return new HashSet<NormalizationGroup>(0);
        }
    }

    @Transactional
    public Set<NormalizationGroup> getAllGlobalForPublishers() {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allGlobalForPublishers");
            return new HashSet<NormalizationGroup>(query.getResultList());
        }
        catch (NoResultException etEx) {
            return new HashSet<NormalizationGroup>(0);
        }
    }

    @Transactional
    public Set<NormalizationGroup> getAllNormalizationGroups() {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.findAll");
            return new HashSet<NormalizationGroup>(query.getResultList());
        }
        catch (NoResultException etEx) {
            return new HashSet<NormalizationGroup>(0);
        }
    }

    @Transactional
    public List<NormalizationGroup> getAllNormalizationGroups(String sortProperty, boolean isAscending) {
        try {
            SearchCriteria criteria = new SearchCriteria();
            Entity e = new Entity("normalizationgroup", NormalizationGroup.class, "norm");
            SortingOrder sortOrder = SortingOrder.ASCENDING;
            if (!isAscending) {
                sortOrder = SortingOrder.DESCENDING;
            }
            e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
            criteria.addParameter((SearchParameterBase)e);
            String s = QueryBuilder.newInstance().buildQuery(criteria);
            Query query = this.entityManager.createQuery(s);
            return query.getResultList();
        }
        catch (NoResultException etEx) {
            return new ArrayList<NormalizationGroup>(0);
        }
    }

    @Transactional
    public void enableGroup(long id) throws DataValidationException {
        NormalizationGroup vg = this.getGroup(id);
        vg.setEnabled(true);
        this.update(vg);
    }

    @Transactional
    public void disableGroup(long id) throws DataValidationException {
        NormalizationGroup vg = this.getGroup(id);
        vg.setEnabled(false);
        this.update(vg);
    }

    private boolean isDuplicateExists(NormalizationGroup normalizationGroup) {
        NormalizationGroup persistedObject = this.getGroupByName(normalizationGroup.getName());
        return persistedObject != null && persistedObject.getId() != normalizationGroup.getId();
    }
}

