/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.rule.Rule;
import com.ericsson.cms.epgmgmt.entity.rule.predicate.Predicate;
import com.ericsson.cms.epgmgmt.service.IRuleManager;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

public class RuleManager<P extends Predicate>
implements IRuleManager<P> {
    private static Log logger = LogFactory.getLog(RuleManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public void create(Rule<P> rule) {
        this.entityManager.persist(rule);
    }

    @Transactional
    public void update(Rule<P> rule) {
        this.entityManager.merge(rule);
    }

    @Transactional
    public Rule<P> getRule(long ruleId) {
        logger.debug((Object)"getRule(long) - start");
        Rule rule = null;
        rule = (Rule)this.entityManager.find(Rule.class, (Object)ruleId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRule(long) - end");
        }
        return rule;
    }

    @Transactional
    public Rule<P> getRuleByName(String name) {
        logger.debug((Object)"getRuleByName(String) - start");
        Rule rule = null;
        try {
            Query query = this.entityManager.createNamedQuery("Rule.byName");
            query.setParameter("NAME", (Object)name);
            rule = (Rule)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            logger.debug((Object)"getRuleByName(String) - end");
            return rule;
        }
        logger.debug((Object)"getRuleByName(String) - end");
        return rule;
    }

    @Transactional
    public void deleteRule(long ruleId) {
        this.entityManager.remove(this.getRule(ruleId));
    }

    @Transactional
    public List<Rule<P>> getAllRulesByRuleType(String type) {
        logger.debug((Object)"getAllRulesByRuleType(String) - start");
        List rules = null;
        Query query = this.entityManager.createNamedQuery("Rule.findAllByRuleType");
        query.setParameter("RULETYPE", (Object)type);
        rules = query.getResultList();
        logger.debug((Object)"getAllRulesByRuleType(String) - end");
        return rules;
    }
}

