/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationRule;
import com.ericsson.cms.epgmgmt.service.DataValidationException;
import com.ericsson.cms.epgmgmt.service.IValidationGroupManager;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class ValidationGroupManager
implements IValidationGroupManager {
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Transactional
    public void create(ValidationGroup validationGroup) throws DataValidationException {
        if (this.isDuplicateExists(validationGroup)) {
            throw new DataValidationException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate"));
        }
        this.entityManager.merge((Object)validationGroup);
    }

    @Transactional
    public void update(ValidationGroup validationGroup) throws DataValidationException {
        if (this.isDuplicateExists(validationGroup)) {
            throw new DataValidationException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate"));
        }
        this.entityManager.merge((Object)validationGroup);
    }

    @Transactional
    public ValidationGroup getGroup(long groupId) {
        return (ValidationGroup)this.entityManager.find(ValidationGroup.class, (Object)groupId);
    }

    @Transactional
    public void removeValidationGroupById(long groupId) {
        this.entityManager.remove((Object)this.getGroup(groupId));
    }

    @Transactional
    public void disasociateRulesFromGroup(long gorupId, List<Long> rules) {
        String ruleIds = StringUtils.join(rules, (String)",");
        if (ruleIds.length() == 0) {
            return;
        }
        String sql = "DELETE VALID_GROUP_RULE_MAPPING WHERE VALID_RULE_GROUP_ID = " + gorupId + " and RULE_ID IN(" + ruleIds + ")";
        Query query = this.entityManager.createNativeQuery(sql);
        query.executeUpdate();
        this.entityManager.flush();
    }

    @Transactional
    public void disasociateProvidersFromGroup(long gorupId, List<Long> providers) {
        String providerIds = StringUtils.join(providers, (String)",");
        if (providerIds.length() == 0) {
            return;
        }
        String sql = "DELETE PARTNER_VALID_GROUP_MAPPING WHERE VALID_GROUP_ID = " + gorupId + " and PARTNER_ID IN(" + providerIds + ")";
        Query query = this.entityManager.createNativeQuery(sql);
        query.executeUpdate();
        this.entityManager.flush();
    }

    @Transactional
    public ValidationGroup getGroupByName(String name) {
        ValidationGroup vGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.byName");
            query.setParameter("NAME", (Object)name);
            vGroup = (ValidationGroup)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return vGroup;
        }
        return vGroup;
    }

    @Transactional
    public List<ValidationRule> getAllRuleAssociationsById(long groupId) {
        List vGroupRules = null;
        ValidationGroup vGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.allRuleAssociationsById");
            query.setParameter("ID", (Object)groupId);
            vGroup = (ValidationGroup)query.getSingleResult();
            if (vGroup != null) {
                vGroupRules = vGroup.getRules();
            }
        }
        catch (NoResultException etEx) {
            return vGroupRules;
        }
        return vGroupRules;
    }

    @Transactional
    public List<Provider> getAllProviderAssociationsById(long groupId) {
        ArrayList<Provider> vGroupProviders = new ArrayList<Provider>();
        ValidationGroup vGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.allPartnerAssociationsById");
            query.setParameter("ID", (Object)groupId);
            vGroup = (ValidationGroup)query.getSingleResult();
            if (vGroup != null) {
                List vGroupPartners = vGroup.getPartners();
                for (Partner p : vGroupPartners) {
                    if (p.getPartnerType() != PartnerTypeEnum.Provider) continue;
                    vGroupProviders.add((Provider)p);
                }
            }
        }
        catch (NoResultException etEx) {
            return vGroupProviders;
        }
        return vGroupProviders;
    }

    @Transactional
    public Set<ValidationGroup> getAllGlobalGroups() {
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.allGlobalRules");
            List nGroup = query.getResultList();
            return new HashSet<ValidationGroup>(nGroup);
        }
        catch (NoResultException etEx) {
            return new HashSet<ValidationGroup>(0);
        }
    }

    @Transactional
    public Set<ValidationGroup> getAllValidationGroups() {
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.findAll");
            List rulesList = query.getResultList();
            return new HashSet<ValidationGroup>(rulesList);
        }
        catch (NoResultException etEx) {
            return new HashSet<ValidationGroup>(0);
        }
    }

    @Transactional
    public List<ValidationGroup> getAllValidationGroups(String sortProperty, boolean isAscending) {
        try {
            SearchCriteria criteria = new SearchCriteria();
            Entity e = new Entity("validationgroup", ValidationGroup.class, "valid");
            SortingOrder sortOrder = SortingOrder.ASCENDING;
            if (!isAscending) {
                sortOrder = SortingOrder.DESCENDING;
            }
            e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
            criteria.addParameter((SearchParameterBase)e);
            String s = QueryBuilder.newInstance().buildQuery(criteria);
            Query query = this.entityManager.createQuery(s);
            return query.getResultList();
        }
        catch (NoResultException etEx) {
            return new ArrayList<ValidationGroup>(0);
        }
    }

    @Transactional
    public void enableGroup(long id) throws DataValidationException {
        ValidationGroup vg = this.getGroup(id);
        vg.setEnabled(true);
        this.update(vg);
    }

    @Transactional
    public void disableGroup(long id) throws DataValidationException {
        ValidationGroup vg = this.getGroup(id);
        vg.setEnabled(false);
        this.update(vg);
    }

    private boolean isDuplicateExists(ValidationGroup validationGroup) {
        ValidationGroup persistedObject = this.getGroupByName(validationGroup.getName());
        return persistedObject != null && persistedObject.getId() != validationGroup.getId();
    }
}

