/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.IEPGExportGuideData;
import com.ericsson.cms.epgmgmt.export.worker.GuideDataExporter;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.utility.time.TimeUtil;
import javax.sql.DataSource;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class EPGExportGuideData
implements IEPGExportGuideData {
    private static Log logger = LogFactory.getLog(EPGExportGuideData.class);
    @Autowired
    @Qualifier(value="h2DataSource")
    private DataSource dataSource;
    private IAlarmActivityLogManager applicationLogger;
    private GuideDataExporter gde;

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void exportGuideData(Task task, ExportETVTypeEnum etvFormat, String tempFolder) throws ExportToXMLException {
        logger.debug((Object)"exportGuideData(String, ExportETVTypeEnum, String) - start");
        String startInfoMsg = String.format("Starting XML generation for publisher %s ", task.getName());
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.EXPORT_TO_XML, startInfoMsg, task.getPartner().getId(), PartnerTypeEnum.Receiver.toString());
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.INFO, "", startInfoMsg, PluginLogComponent.EXPORT_TO_XML));
        StopWatch watch = new StopWatch();
        watch.start();
        this.gde = new GuideDataExporter(etvFormat, tempFolder, this.dataSource, task.getPartner().getId());
        this.gde.execute();
        this.logResult(task, watch.getTime());
        watch.stop();
        logger.debug((Object)"exportGuideData(String, ExportETVTypeEnum, String) - end");
    }

    @Override
    @Transactional
    public void stopExportingGuideData() {
        if (this.gde == null) {
            logger.debug((Object)"stopExportingGuideData() - no active GuideDataExporter");
            return;
        }
        this.gde.shutdown();
    }

    private void logResult(Task task, long duration) {
        String activityLogHead = String.format("XML generation for publisher %s (took %s).", task.getName(), TimeUtil.getTimeTook((long)duration));
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.EXPORT_TO_XML, "Finished " + activityLogHead, task.getPartner().getId(), PartnerTypeEnum.Receiver.toString());
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.INFO, "", "Finished " + activityLogHead, PluginLogComponent.EXPORT_TO_XML));
    }

    public void setDataSource(DataSource datasource) {
        this.dataSource = datasource;
    }

    @Autowired
    public void setApplicationLogger(IAlarmActivityLogManager applicationLogger) {
        this.applicationLogger = applicationLogger;
    }
}

